% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hist.R
\name{get_data}
\alias{get_data}
\title{Get Data from the Yahoo Finance API}
\usage{
get_data(symbols, from_date = "2007-01-01", to_date = NULL,
  interval = "1d")
}
\arguments{
\item{symbols}{string. Symbol or vector of symbols.}

\item{from_date}{string. Start date in \code{"YYYY-MM-DD"} format (e.g., \code{"2007-01-01"}).}

\item{to_date}{string. End date in \code{"YYYY-MM-DD"} format.}

\item{interval}{string. Data interval (see \code{"data_intervals"}).}
}
\value{
A data frame or list of data frame(s) that contains data from the
Yahoo Finance API for the specified symbol(s).
}
\description{
A function to get data from the Yahoo Finance API for symbols using a date 
range and interval.
}
\examples{
\dontrun{
data <- get_data(c("AAPL", "MSFT"))
}
}
