% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fair-aaa.R
\name{new_groupwise_metric}
\alias{new_groupwise_metric}
\title{Create groupwise metrics}
\usage{
new_groupwise_metric(fn, name, aggregate, direction = "minimize")
}
\arguments{
\item{fn}{A yardstick metric function or metric set.}

\item{name}{The name of the metric to place in the \code{.metric} column
of the output.}

\item{aggregate}{A function to summarize the generated metric set results.
The function takes metric set results as the first argument and returns
a single numeric giving the \code{.estimate} value as output. See the Value and
Examples sections for example uses.}

\item{direction}{A string. One of:
\itemize{
\item \code{"maximize"}
\item \code{"minimize"}
\item \code{"zero"}
}}
}
\value{
This function is a
\href{https://adv-r.hadley.nz/function-factories.html}{function factory}; its
output is itself a function. Further, the functions that this function
outputs are also function factories. More explicitly, this looks like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# a function with similar implementation to `demographic_parity()`:
diff_range <- function(x) \{diff(range(x$.estimate))\}

dem_parity <-
  new_groupwise_metric(
    fn = detection_prevalence,
    name = "dem_parity",
    aggregate = diff_range
  )
}\if{html}{\out{</div>}}

The outputted \code{dem_parity} is a function that takes one argument, \code{by},
indicating the data-masked variable giving the sensitive feature.

When called with a \code{by} argument, \code{dem_parity} will return a yardstick
metric function like any other:

\if{html}{\out{<div class="sourceCode">}}\preformatted{dem_parity_by_gender <- dem_parity(gender)
}\if{html}{\out{</div>}}

Note that \code{dem_parity} doesn't take any arguments other than \code{by}, and thus
knows nothing about the data it will be applied to other than that it ought
to have a column with name \code{"gender"} in it.

The output \code{dem_parity_by_gender} is a metric function that takes the
same arguments as the function supplied as \code{fn}, in this case
\code{detection_prevalence}. It will thus interface like any other yardstick
function except that it will look for a \code{"gender"} column in
the data it's supplied.

In addition to the examples below, see the documentation on the
return value of fairness metrics like \code{\link[=demographic_parity]{demographic_parity()}},
\code{\link[=equal_opportunity]{equal_opportunity()}}, or \code{\link[=equalized_odds]{equalized_odds()}} to learn more about how the
output of this function can be used.
}
\description{
Groupwise metrics quantify the disparity in value of a metric across a
number of groups. Groupwise metrics with a value of zero indicate that the
underlying metric is equal across groups. yardstick defines
several common fairness metrics using this function, such as
\code{\link[=demographic_parity]{demographic_parity()}}, \code{\link[=equal_opportunity]{equal_opportunity()}}, and \code{\link[=equalized_odds]{equalized_odds()}}.
}
\details{
Note that \emph{all} yardstick metrics are group-aware in that, when passed
grouped data, they will return metric values calculated for each group.
When passed grouped data, groupwise metrics also return metric values
for each group, but those metric values are calculated by first additionally
grouping by the variable passed to \code{by} and then summarizing the per-group
metric estimates across groups using the function passed as the
\code{aggregate} argument. Learn more about grouping behavior in yardstick using
\code{vignette("grouping", "yardstick")}.
}
\section{Relevant Group Level}{

Additional arguments can be passed to the function outputted by
the function that this function outputs. That is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{res_fairness <- new_groupwise_metric(...)
res_by <- res_fairness(by)
res_by(..., additional_arguments_to_aggregate = TRUE)
}\if{html}{\out{</div>}}

For finer control of how groups in \code{by} are treated, use the
\code{aggregate} argument.
}

\examples{
data(hpc_cv)

# `demographic_parity`, among other fairness metrics,
# is generated with `new_groupwise_metric()`:
diff_range <- function(x) {diff(range(x$.estimate))}
demographic_parity_ <-
  new_groupwise_metric(
    fn = detection_prevalence,
    name = "demographic_parity",
    aggregate = diff_range
  )

m_set <- metric_set(demographic_parity_(Resample))

m_set(hpc_cv, truth = obs, estimate = pred)

# the `post` argument can be used to accommodate a wide
# variety of parameterizations. to encode demographic
# parity as a ratio inside of a difference, for example:
ratio_range <- function(x, ...) {
  range <- range(x$.estimate)
  range[1] / range[2]
}

demographic_parity_ratio <-
  new_groupwise_metric(
    fn = detection_prevalence,
    name = "demographic_parity_ratio",
    aggregate = ratio_range
  )

}
