% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvec.R
\name{c.dvec}
\alias{c.dvec}
\title{Combine Decorated Vector}
\usage{
\method{c}{dvec}(...)
}
\arguments{
\item{...}{items to be combined, presumably all vectors}
}
\value{
dvec
}
\description{
Combines decorated vectors.  Tries to preserve
attributes by resolving pairwise conflicts intelligently.
The attributes of the first item are reconciled
with those of the second, then those of the third, etc.
the \code{class} attribute is untouched.
}
\details{
By default, the first version of any attribute is
preserved, with warning if the alternative differs.
NULLs are largely ignored. If either attribute
is a list the other is coerced to a list with as.list().
If either of two lists has names, then names
are enforced for the other (blank names if necessary).
Lists are combined in forward order, and
elements that are duplicates in value and name (if present)
are removed.  If the result has only blank names,
these are removed as well.
}
\examples{
a <- as_dvec(letters[1:3], label = 'foo', priority = 1)
b <- as_dvec(letters[3:5], label = 'foo', case = 'lower')
c <- c(a,b)
c
class(c)

}
\seealso{
Other dvec: 
\code{\link{[.dvec}()},
\code{\link{[<-.dvec}()},
\code{\link{[[.dvec}()},
\code{\link{[[<-.dvec}()},
\code{\link{as.data.frame.dvec}()},
\code{\link{as_dvec}()},
\code{\link{as_dvec.character}()},
\code{\link{as_dvec.complex}()},
\code{\link{as_dvec.dvec}()},
\code{\link{as_dvec.integer}()},
\code{\link{as_dvec.logical}()},
\code{\link{as_dvec.numeric}()},
\code{\link{classified.dvec}()},
\code{\link{desolve.dvec}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{format.dvec}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{implicit_guide.factor}()},
\code{\link{length.dvec}()},
\code{\link{print.dvec}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.dvec}()},
\code{\link{resolve.factor}()},
\code{\link{unclassified.dvec}()}
}
\concept{dvec}
\keyword{internal}
