% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.xtvfreg}
\alias{summary.xtvfreg}
\title{Summary method for xtvfreg objects}
\usage{
\method{summary}{xtvfreg}(object, ...)
}
\arguments{
\item{object}{An object of class "xtvfreg"}

\item{...}{Additional arguments (currently unused)}
}
\value{
Invisibly returns the input object
}
\description{
Summary method for xtvfreg objects
}
\examples{
set.seed(456)
n_id <- 30
n_time <- 4
panel_data <- data.frame(
  id = rep(1:n_id, each = n_time),
  group = rep(c("A", "B"), length.out = n_id * n_time),
  x = rnorm(n_id * n_time)
)
panel_data$m_x <- ave(panel_data$x, panel_data$id, FUN = mean)
panel_data$d_x <- panel_data$x - panel_data$m_x
panel_data$y <- 1 + panel_data$m_x + rnorm(n_id * n_time)

result <- xtvfreg(
  formula = y ~ 1,
  data = panel_data,
  group = "group",
  panel_id = "id",
  mean_vars = c("m_x", "d_x"),
  var_vars = "m_x",
  verbose = FALSE
)

summary(result)
}
