% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{xportr_format}
\alias{xportr_format}
\title{Assign SAS Format}
\usage{
xportr_format(.df, metadata = NULL, domain = NULL, verbose = NULL)
}
\arguments{
\item{.df}{A data frame of CDISC standard.}

\item{metadata}{A metacore object or a data frame containing variable level metadata. See
'Metadata' section for details.}

\item{domain}{Appropriate CDISC dataset name, e.g. ADAE, DM. Used to subset
the metadata object.}

\item{verbose}{The action this function takes when an action is taken on the
dataset or function validation finds an issue. See 'Messaging' section for
details. Options are 'stop', 'warn', 'message', and 'none'}
}
\value{
Data frame with \code{SASformat} attributes for each variable.
}
\description{
Assigns a SAS format from a variable level metadata to a given data frame. If
no format is found for a given variable, it is set as an empty character
vector. This is stored in the '\code{format.sas}' attribute.
}
\section{Format Checks}{
 This function carries out a series of basic
checks to ensure the formats being applied make sense.

Note, the 'type' of message that is generated will depend on the value
passed to the \code{verbose} argument: with 'stop' producing an error, 'warn'
producing a warning, or 'message' producing a message. A value of 'none'
will not output any messages.
\enumerate{
\item If the variable has a suffix of \code{DT}, \code{DTM}, or \code{TM} excluding \code{ELTM}
(indicating a numeric date/time variable) , then a message will be shown
if there is no format associated with it.
\item If a variable is character then a message will be shown if there is
no \code{$} prefix in the associated format.
\item If a variable is character then a message will be shown if the
associated format has greater than 31 characters (excluding the \code{$}).
\item If a variable is numeric then a message will be shown if there is a
\code{$} prefix in the associated format.
\item If a variable is numeric then a message will be shown if the
associated format has greater than 32 characters.
\item All formats will be checked against a list of formats considered
'standard' as part of an ADaM dataset. Note, however, this list is not
exhaustive (it would not be feasible to check all the functions
within the scope of this package). If the format is not found in the
'standard' list, then a message is created advising the user to
check.
}\tabular{lll}{
   \strong{Format Name} \tab \strong{w Values} \tab \strong{d Values} \cr
   w.d \tab 1 - 32 \tab ., 0 - 31 \cr
   $w. \tab 1 - 200 \tab  \cr
   DATEw. \tab ., 5 - 11 \tab  \cr
   DATETIMEw. \tab 7 - 40 \tab  \cr
   DDMMYYw. \tab ., 2 - 10 \tab  \cr
   HHMM. \tab  \tab  \cr
   MMDDYYw. \tab ., 2 - 10 \tab  \cr
   TIMEw. \tab ., 2 - 20 \tab  \cr
   WEEKDATEw. \tab ., 3 - 37 \tab  \cr
   YYMMDDw. \tab ., 2 - 10 \tab  \cr
   B8601DAw. \tab ., 8 - 10 \tab  \cr
   B8601DTw.d \tab ., 15 - 26 \tab ., 0 - 6 \cr
   B8601TM. \tab  \tab  \cr
   IS8601DA. \tab  \tab  \cr
   IS8601TM. \tab  \tab  \cr
   E8601DAw. \tab ., 10 \tab  \cr
   E8601DNw. \tab ., 10 \tab  \cr
   E8601DTw.d \tab ., 16 - 26 \tab ., 0 - 6 \cr
   E8601DXw. \tab ., 20 - 35 \tab  \cr
   E8601LXw. \tab ., 20 - 35 \tab  \cr
   E8601LZw. \tab ., 9 - 20 \tab  \cr
   E8601TMw.d \tab ., 8 - 15 \tab ., 0 - 6 \cr
   E8601TXw. \tab ., 9 - 20 \tab  \cr
   E8601TZw.d \tab ., 9 - 20 \tab ., 0 - 6 \cr
}
}

\section{Metadata}{
 The argument passed in the 'metadata' argument can either
be a metacore object, or a data.frame containing the data listed below. If
metacore is used, no changes to options are required.

For data.frame 'metadata' arguments three columns must be present:
\enumerate{
\item Domain Name - passed as the 'xportr.domain_name' option. Default:
"dataset". This is the column subset by the 'domain' argument in the
function.
\item Format Name - passed as the 'xportr.format_name' option. Default:
"format". Character values to update the '\code{format.sas}' attribute of the
column. This is passed to \code{haven::write_xpt} to note the format.
\item Variable Name - passed as the 'xportr.variable_name' option. Default:
"variable". This is used to match columns in '.df' argument and the
metadata.
}
}

\examples{
adsl <- data.frame(
  USUBJID = c(1001, 1002, 1003),
  BRTHDT = c(1, 1, 2)
)

metadata <- data.frame(
  dataset = c("adsl", "adsl"),
  variable = c("USUBJID", "BRTHDT"),
  format = c(NA, "DATE9.")
)

adsl <- xportr_format(adsl, metadata, domain = "adsl")
}
