/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.usermodel.Slide;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.sl.usermodel.SlideShowFactory;
import org.apache.poi.util.JvmBugs;

public class PPTX2PNG {
    static void usage(String error) {
        String msg = "Usage: PPTX2PNG [options] <ppt or pptx file>\n" + (error == null ? "" : "Error: " + error + "\n") + "Options:\n" + "    -scale <float>   scale factor\n" + "    -slide <integer> 1-based index of a slide to render\n" + "    -format <type>   png,gif,jpg (,null for testing)" + "    -outdir <dir>    output directory, defaults to origin of the ppt/pptx file" + "    -quite           do not write to console (for normal processing)";
        System.out.println(msg);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            PPTX2PNG.usage(null);
            return;
        }
        int slidenum = -1;
        float scale = 1.0f;
        File file = null;
        String format = "png";
        File outdir = null;
        boolean quite = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if ("-scale".equals(args[i])) {
                    scale = Float.parseFloat(args[++i]);
                    continue;
                }
                if ("-slide".equals(args[i])) {
                    slidenum = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-format".equals(args[i])) {
                    format = args[++i];
                    continue;
                }
                if ("-outdir".equals(args[i])) {
                    outdir = new File(args[++i]);
                    continue;
                }
                if (!"-quite".equals(args[i])) continue;
                quite = true;
                continue;
            }
            file = new File(args[i]);
        }
        if (file == null || !file.exists()) {
            PPTX2PNG.usage("File not specified or it doesn't exist");
            return;
        }
        if (outdir == null) {
            outdir = file.getParentFile();
        }
        if (outdir == null || !outdir.exists() || !outdir.isDirectory()) {
            PPTX2PNG.usage("Output directory doesn't exist");
            return;
        }
        if (scale < 0.0f) {
            PPTX2PNG.usage("Invalid scale given");
            return;
        }
        if (format == null || !format.matches("^(png|gif|jpg|null)$")) {
            PPTX2PNG.usage("Invalid format given");
            return;
        }
        if (!quite) {
            System.out.println("Processing " + file);
        }
        SlideShow ss = SlideShowFactory.create((File)file, null, (boolean)true);
        List slides = ss.getSlides();
        if (slidenum < -1 || slidenum == 0 || slidenum > slides.size()) {
            PPTX2PNG.usage("slidenum must be either -1 (for all) or within range: [1.." + slides.size() + "] for " + file);
            return;
        }
        Dimension pgsize = ss.getPageSize();
        int width = (int)((float)pgsize.width * scale);
        int height = (int)((float)pgsize.height * scale);
        int slideNo = 1;
        for (Slide slide : slides) {
            if (slidenum == -1 || slideNo == slidenum) {
                String title = slide.getTitle();
                if (!quite) {
                    System.out.println("Rendering slide " + slideNo + (title == null ? "" : ": " + title));
                }
                BufferedImage img = new BufferedImage(width, height, 2);
                Graphics2D graphics = img.createGraphics();
                PPTX2PNG.fixFonts(graphics);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics.scale(scale, scale);
                slide.draw(graphics);
                if (!"null".equals(format)) {
                    String outname = file.getName().replaceFirst(".pptx?", "");
                    outname = String.format(Locale.ROOT, "%1$s-%2$04d.%3$s", outname, slideNo, format);
                    File outfile = new File(outdir, outname);
                    ImageIO.write((RenderedImage)img, format, outfile);
                }
            }
            ++slideNo;
        }
        if (!quite) {
            System.out.println("Done");
        }
    }

    private static void fixFonts(Graphics2D graphics) {
        if (!JvmBugs.hasLineBreakMeasurerBug()) {
            return;
        }
        HashMap<String, String> fontMap = (HashMap<String, String>)graphics.getRenderingHint((RenderingHints.Key)Drawable.FONT_MAP);
        if (fontMap == null) {
            fontMap = new HashMap<String, String>();
        }
        fontMap.put("Calibri", "Lucida Sans");
        fontMap.put("Cambria", "Lucida Bright");
        graphics.setRenderingHint((RenderingHints.Key)Drawable.FONT_MAP, fontMap);
    }
}

