/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.RectangularShape;
import org.apache.poi.sl.usermodel.FreeformShape;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFAutoShape;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTAdjPoint2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTCustomGeometry2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGeomRect;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2D;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DClose;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DCubicBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DLineTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DMoveTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DQuadBezierTo;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShapeNonVisual;

public class XSLFFreeformShape
extends XSLFAutoShape
implements FreeformShape<XSLFShape, XSLFTextParagraph> {
    XSLFFreeformShape(CTShape shape, XSLFSheet sheet) {
        super(shape, sheet);
    }

    public int setPath(GeneralPath path) {
        CTPath2D ctPath = CTPath2D.Factory.newInstance();
        Rectangle bounds = path.getBounds();
        int x0 = Units.toEMU((double)bounds.getX());
        int y0 = Units.toEMU((double)bounds.getY());
        PathIterator it = path.getPathIterator(new AffineTransform());
        int numPoints = 0;
        ctPath.setH((long)Units.toEMU((double)bounds.getHeight()));
        ctPath.setW((long)Units.toEMU((double)bounds.getWidth()));
        while (!it.isDone()) {
            double[] vals = new double[6];
            int type = it.currentSegment(vals);
            switch (type) {
                case 0: {
                    CTAdjPoint2D mv = ctPath.addNewMoveTo().addNewPt();
                    mv.setX((Object)(Units.toEMU((double)vals[0]) - x0));
                    mv.setY((Object)(Units.toEMU((double)vals[1]) - y0));
                    ++numPoints;
                    break;
                }
                case 1: {
                    CTAdjPoint2D ln = ctPath.addNewLnTo().addNewPt();
                    ln.setX((Object)(Units.toEMU((double)vals[0]) - x0));
                    ln.setY((Object)(Units.toEMU((double)vals[1]) - y0));
                    ++numPoints;
                    break;
                }
                case 2: {
                    CTPath2DQuadBezierTo qbez = ctPath.addNewQuadBezTo();
                    CTAdjPoint2D qp1 = qbez.addNewPt();
                    qp1.setX((Object)(Units.toEMU((double)vals[0]) - x0));
                    qp1.setY((Object)(Units.toEMU((double)vals[1]) - y0));
                    CTAdjPoint2D qp2 = qbez.addNewPt();
                    qp2.setX((Object)(Units.toEMU((double)vals[2]) - x0));
                    qp2.setY((Object)(Units.toEMU((double)vals[3]) - y0));
                    numPoints += 2;
                    break;
                }
                case 3: {
                    CTPath2DCubicBezierTo bez = ctPath.addNewCubicBezTo();
                    CTAdjPoint2D p1 = bez.addNewPt();
                    p1.setX((Object)(Units.toEMU((double)vals[0]) - x0));
                    p1.setY((Object)(Units.toEMU((double)vals[1]) - y0));
                    CTAdjPoint2D p2 = bez.addNewPt();
                    p2.setX((Object)(Units.toEMU((double)vals[2]) - x0));
                    p2.setY((Object)(Units.toEMU((double)vals[3]) - y0));
                    CTAdjPoint2D p3 = bez.addNewPt();
                    p3.setX((Object)(Units.toEMU((double)vals[4]) - x0));
                    p3.setY((Object)(Units.toEMU((double)vals[5]) - y0));
                    numPoints += 3;
                    break;
                }
                case 4: {
                    ++numPoints;
                    ctPath.addNewClose();
                }
            }
            it.next();
        }
        this.getSpPr().getCustGeom().getPathLst().setPathArray(new CTPath2D[]{ctPath});
        this.setAnchor(bounds);
        return numPoints;
    }

    public GeneralPath getPath() {
        GeneralPath path = new GeneralPath();
        Rectangle bounds = this.getAnchor();
        CTCustomGeometry2D geom = this.getSpPr().getCustGeom();
        for (CTPath2D spPath : geom.getPathLst().getPathArray()) {
            double scaleW = ((RectangularShape)bounds).getWidth() / Units.toPoints((long)spPath.getW());
            double scaleH = ((RectangularShape)bounds).getHeight() / Units.toPoints((long)spPath.getH());
            for (XmlObject ch : spPath.selectPath("*")) {
                CTAdjPoint2D pt2;
                CTAdjPoint2D pt1;
                CTPath2DQuadBezierTo bez;
                CTAdjPoint2D pt;
                if (ch instanceof CTPath2DMoveTo) {
                    pt = ((CTPath2DMoveTo)ch).getPt();
                    path.moveTo((float)(Units.toPoints((long)((Long)pt.getX())) * scaleW), (float)(Units.toPoints((long)((Long)pt.getY())) * scaleH));
                    continue;
                }
                if (ch instanceof CTPath2DLineTo) {
                    pt = ((CTPath2DLineTo)ch).getPt();
                    path.lineTo((float)Units.toPoints((long)((Long)pt.getX())), (float)Units.toPoints((long)((Long)pt.getY())));
                    continue;
                }
                if (ch instanceof CTPath2DQuadBezierTo) {
                    bez = (CTPath2DQuadBezierTo)ch;
                    pt1 = bez.getPtArray(0);
                    pt2 = bez.getPtArray(1);
                    path.quadTo((float)(Units.toPoints((long)((Long)pt1.getX())) * scaleW), (float)(Units.toPoints((long)((Long)pt1.getY())) * scaleH), (float)(Units.toPoints((long)((Long)pt2.getX())) * scaleW), (float)(Units.toPoints((long)((Long)pt2.getY())) * scaleH));
                    continue;
                }
                if (ch instanceof CTPath2DCubicBezierTo) {
                    bez = (CTPath2DCubicBezierTo)ch;
                    pt1 = bez.getPtArray(0);
                    pt2 = bez.getPtArray(1);
                    CTAdjPoint2D pt3 = bez.getPtArray(2);
                    path.curveTo((float)(Units.toPoints((long)((Long)pt1.getX())) * scaleW), (float)(Units.toPoints((long)((Long)pt1.getY())) * scaleH), (float)(Units.toPoints((long)((Long)pt2.getX())) * scaleW), (float)(Units.toPoints((long)((Long)pt2.getY())) * scaleH), (float)(Units.toPoints((long)((Long)pt3.getX())) * scaleW), (float)(Units.toPoints((long)((Long)pt3.getY())) * scaleH));
                    continue;
                }
                if (!(ch instanceof CTPath2DClose)) continue;
                path.closePath();
            }
        }
        AffineTransform at = new AffineTransform();
        at.translate(((RectangularShape)bounds).getX(), ((RectangularShape)bounds).getY());
        return new GeneralPath(at.createTransformedShape(path));
    }

    static CTShape prototype(int shapeId) {
        CTShape ct = CTShape.Factory.newInstance();
        CTShapeNonVisual nvSpPr = ct.addNewNvSpPr();
        CTNonVisualDrawingProps cnv = nvSpPr.addNewCNvPr();
        cnv.setName("Freeform " + shapeId);
        cnv.setId((long)(shapeId + 1));
        nvSpPr.addNewCNvSpPr();
        nvSpPr.addNewNvPr();
        CTShapeProperties spPr = ct.addNewSpPr();
        CTCustomGeometry2D geom = spPr.addNewCustGeom();
        geom.addNewAvLst();
        geom.addNewGdLst();
        geom.addNewAhLst();
        geom.addNewCxnLst();
        CTGeomRect rect = geom.addNewRect();
        rect.setR((Object)"r");
        rect.setB((Object)"b");
        rect.setT((Object)"t");
        rect.setL((Object)"l");
        geom.addNewPathLst();
        return ct;
    }
}

