% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeCodonPrecision.R
\name{CodonChoiceBiasesDeprecated}
\alias{CodonChoiceBiasesDeprecated}
\title{Biases in Rule Choice (Deprecated)}
\usage{
CodonChoiceBiasesDeprecated(cv, precision)
}
\arguments{
\item{cv}{Choice vector of grammar.}

\item{precision}{Number of bits of codon.}
}
\value{
Data frame with the following columns
        \itemize{
        \item \code{$precision}: Number of bits.
        \item \code{$cv}:   i-th element of choice the vector.
        \item \code{$dp}:   Deviation from choice with equal probability for \code{$precision}.
        \item \code{$dH}:   Entropy difference between choice with equal probability 
                            and biased choice for \code{$precision}.
        }
}
\description{
See \code{CodonChoiceBiases}. 
             The use of the outer product leads to memory problems for 
             \code{precision>31} and becomes slow for \code{precision>24}.
}
\examples{
 CodonChoiceBiasesDeprecated(c(1, 2, 3, 5), 3)
 CodonChoiceBiasesDeprecated(c(1, 2, 3, 5), 5)
}
\seealso{
Other Diagnostics: 
\code{\link{CodonChoiceBiases}()},
\code{\link{CodonPrecision}()},
\code{\link{tLCM}()}
}
\concept{Diagnostics}
