% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeCodonPrecision.R
\name{CodonChoiceBiases}
\alias{CodonChoiceBiases}
\title{Biases in Rule Choice.}
\usage{
CodonChoiceBiases(cv, precision)
}
\arguments{
\item{cv}{Choice vector of grammar.}

\item{precision}{Number of bits of codon.}
}
\value{
Data frame with the following columns
        \itemize{
        \item \code{$precision}: Number of bits.
        \item \code{$cv}:   i-th element of the choice vector.
        \item \code{$dp}:   Deviation from choice with equal probability for \code{$precision}.
        \item \code{$dH}:   Entropy difference between choice with equal probability 
                            and biased choice for \code{$precision}.
        }
}
\description{
Measures the biases in rule choice for each non-terminal.
             Statistics computed:
             \itemize{
             \item dP: Difference in probability  
                       between random choice with equal 
                       probability and modulo rule with a codon 
                       \code{precision}.
             \item dH: Difference in entropy  
                       between random choice with equal 
                       probability and modulo rule with a codon 
                       \code{precision}.
                       }
}
\examples{
 CodonChoiceBiases(c(1, 2, 3, 5), 3)
 CodonChoiceBiases(c(1, 2, 3, 5), 5)
}
\seealso{
Other Diagnostics: 
\code{\link{CodonChoiceBiasesDeprecated}()},
\code{\link{CodonPrecision}()},
\code{\link{tLCM}()}
}
\concept{Diagnostics}
