% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geTree.R
\name{decodeAndFixDT}
\alias{decodeAndFixDT}
\title{Decodes (and completes) a derivation tree into a working program.}
\usage{
decodeAndFixDT(tree, G, kvec)
}
\arguments{
\item{tree}{Derivation tree.}

\item{G}{A Grammar object.}

\item{kvec}{A random integer vector.}
}
\value{
A program
}
\description{
The program is guaranteed to work.
}
\examples{
g<-compileBNF(booleanGrammar())
complete<-TRUE
while (complete) {
t1<-generateDerivationTree(sym=g$Start, kvec=sample(100, 10, replace=TRUE), G=g)
complete<-t1$complete}
decodeAndFixDT(t1$tree, G=g, kvec=sample(100, 10, replace=TRUE)) 

}
\seealso{
Other Decoder: 
\code{\link{decodeCDT}()},
\code{\link{decodeDT}()},
\code{\link{decodeDTsym}()},
\code{\link{decodeTree}()},
\code{\link{leavesIncompleteDT}()}
}
\concept{Decoder}
