% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcKVA.R
\name{calcKVA}
\alias{calcKVA}
\title{Calculates the Capital Valuation Adjustment (KVA)}
\usage{
calcKVA(
  trades,
  reg_data,
  EAD,
  effective_maturity,
  ignore_def_charge = TRUE,
  cva_capital_charge
)
}
\arguments{
\item{trades}{The full list of the Trade Objects}

\item{reg_data}{A list containing data related to the regulatory calculations (for example the 'framework' member variable can be 'IMM','SACCR','CEM')}

\item{EAD}{The Exposure-at-default calculated based on the prescribed framework as appearing in the 'reg_data'}

\item{effective_maturity}{The effective maturity of the trades performed with a specific counterparty}

\item{ignore_def_charge}{if set to true the default capital charge is set to zero}

\item{cva_capital_charge}{The CVA Capital Charge linked to this portfolio}
}
\value{
The capital valuation adjustment (KVA)
}
\description{
Calculates the capital valuation adjustment by computing the default capital charge and the CVA capital charge and applying the required return-on-capital
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
