% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_moderation_curve.R
\name{plot_moderation_curve}
\alias{plot_moderation_curve}
\title{Plot moderation curves with Johnson-Neyman highlights}
\usage{
plot_moderation_curve(
  result,
  path_name,
  title = NULL,
  x_label = "Moderator (W)",
  y_label = "Estimate",
  ns_fill = "#FEE0D2",
  sig_fill = "#C7E9C0",
  alpha_ci = 0.35,
  alpha_sig = 0.35,
  base_size = 14
)
}
\arguments{
\item{result}{A \code{wsMed()} result that contains a \verb{$moderation} element.}

\item{path_name}{Exact name of the path to plot (e.g. \code{"indirect_1_2"} or
\code{"b_1_2"}).  When the name exists in both curves, \code{theta_curve} is used.}

\item{title}{Optional plot title (default
\code{sprintf("Effect Curve: (\%s)", path_name)}).}

\item{x_label, y_label}{Axis labels.  Defaults are \code{"Moderator (W)"} and
\code{"Estimate"}.}

\item{ns_fill, sig_fill}{Fill colours for the confidence band and the
significant regions.}

\item{alpha_ci, alpha_sig}{Alpha values for the two ribbons.}

\item{base_size}{Base font size passed to \code{ggplot2::theme_minimal()}.}
}
\value{
A \code{ggplot} object (add layers or save with \code{ggsave()}).
}
\description{
\code{plot_moderation_curve()} visualises how an indirect effect
(\code{theta_curve}) or a path coefficient (\code{path_curve}) varies along a
continuous moderator \emph{W}.

The routine
\itemize{
\item extracts the requested record (\code{path_name}) from \code{result$moderation},
preferring \code{theta_curve} when it is available in both curves;
\item draws the conditional effect (\code{Estimate}) against the raw moderator grid
(\code{W_raw});
\item overlays the Monte-Carlo confidence band (\code{CI.LL}, \code{CI.UL}) and finds every
Johnson–Neyman segment whose 95 \% CI excludes zero
(\code{CI.LL * CI.UL > 0});
\item shades these significant regions and annotates each with its start /
end percentiles (for example, \code{"sig 12.5\%-38.3\%"}).
}

Visual elements
\itemize{
\item \strong{Red ribbon}   – overall 95 \% confidence band (\code{ns_fill});
\item \strong{Green ribbon} – significant Johnson–Neyman intervals (\code{sig_fill});
\item \strong{Solid line}   – point estimate;
\item \strong{Dashed h-line} – zero reference;
\item \strong{Dashed v-lines} – J–N bounds.
}
}
