% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_mm_continuous.R
\name{analyze_mm_continuous}
\alias{analyze_mm_continuous}
\title{Conditional Indirect Effects with a Continuous Moderator}
\usage{
analyze_mm_continuous(
  mc_result,
  data,
  MP,
  W_raw_name = "W",
  ci_level = 0.95,
  W_values = NULL,
  n_curve = 120,
  digits = 8
)
}
\arguments{
\item{mc_result}{A \code{semmcci} object returned by \code{MCMI2()}.}

\item{data}{A processed data frame (first element of
\code{PrepareData()} output) that contains the raw moderator column.}

\item{W_raw_name}{Name of the moderator column in \code{data}.
Default \code{"W"}.}

\item{ci_level}{Two-sided confidence level (default \code{0.95}).}

\item{W_values}{Numeric vector of raw \emph{W} values at which to
evaluate “Low / Mid / High” effects.
If \code{NULL} (default) the vector \eqn{mean(W) ± 1\,SD} is used.}

\item{n_curve}{Integer, number of points used to draw the continuous
effect curve (default \code{120}).}

\item{digits}{Integer, decimal places for rounding (default \code{3}).}
}
\value{
A named list with components:
\describe{
\item{\code{mod_coeff}}{Moderated path coefficients (\code{aw},
\code{bw}, …).}
\item{\code{beta_coef}}{Indirect effect at –1 SD / 0 SD / +1 SD.}
\item{\code{path_HML}}{Moderated base paths at the three W levels.}
\item{\code{theta_curve}}{Data frame of the indirect effect curve.}
\item{\code{path_curve}}{Data frame of each moderated base-path
curve.}
}
}
\description{
Summarises Monte-Carlo draws from a \code{semmcci} object when the
moderator \emph{W} is \strong{continuous}.
The function outputs:
\enumerate{
\item \bold{mod_coeff}   – table of every moderated path coefficient
(\code{aw}, \code{bw}, \code{dw}, \code{cpw}) with its base
counterpart and 95 \% CI;
\item \bold{beta_coef}   – indirect effect at three reference points
of \emph{W} (–1 SD, mean, +1 SD);
\item \bold{path_HML}    – likewise, the moderated primary paths
(\code{a}, \code{b}, …) at the three W levels;
\item \bold{theta_curve} – full curve of the indirect effect over a
user-defined grid of centred \emph{W};
\item \bold{path_curve}  – full curve for every moderated base path.
}
Significance stars (\code{"*"}) are added where the CI excludes 0.
}
\keyword{internal}
