% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MICombineWrapper.R
\name{MICombineWrapper}
\alias{MICombineWrapper}
\title{Wrapper for Internal Multiple Imputation Combining Function}
\usage{
MICombineWrapper(coefs, vcovs, M, k, adj = FALSE)
}
\arguments{
\item{coefs}{A list of numeric vectors, where each vector contains the parameter estimates from one
imputed dataset.}

\item{vcovs}{A list of numeric matrices, where each matrix represents the covariance matrix of the
parameter estimates for one imputed dataset.}

\item{M}{An integer indicating the number of imputations.}

\item{k}{An integer specifying the number of parameters in the SEM model.}

\item{adj}{A logical value indicating whether to apply an adjustment for finite samples. Default is \code{TRUE}.}
}
\value{
A list containing the pooled estimates and covariance matrix:
\itemize{
\item \code{est}: A numeric vector of pooled parameter estimates.
\item \code{total}: A numeric matrix representing the pooled covariance matrix.
}
}
\description{
A wrapper function for the internal \code{.MICombine()} function from the \code{semmcci} package.
This function pools parameter estimates and covariance matrices from multiple imputed datasets
using Rubin's rules.
}
\details{
This wrapper provides an abstraction over the internal \code{.MICombine()} function from the \code{semmcci} package,
allowing it to be used within your package without directly exposing the internal function.
It is primarily designed for use within workflows that involve multiple imputation and structural
equation modeling (SEM). Rubin's rules are applied to compute pooled parameter estimates and their
covariance matrices.
}
\seealso{
\code{\link[=RunMCMIAnalysis]{RunMCMIAnalysis()}}
}
\keyword{internal}
