% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{pairwise_ordcat_test}
\alias{pairwise_ordcat_test}
\title{Pairwise comparison for ordinal categories}
\usage{
pairwise_ordcat_test(
  dep_var,
  indep_var,
  adjmethod = "fdr",
  plevel = 0.05,
  symbols = letters[-1],
  ref = FALSE,
  cmh = TRUE
)
}
\arguments{
\item{dep_var}{dependent variable, containing the data}

\item{indep_var}{independent variable, should be factor}

\item{adjmethod}{method for adjusting p values (see \link{p.adjust})}

\item{plevel}{threshold for significance}

\item{symbols}{predefined as b,c, d...;  provides footnotes to mark group
differences, e.g. b means different from group 2}

\item{ref}{is the 1st subgroup the reference (like in Dunnett test)}

\item{cmh}{Should  Cochran-Mantel-Haenszel test (\link[coin:ContingencyTests]{coin::cmh_test}) be used for
testing? If false, the linear-by-linear association test (\link[coin:ContingencyTests]{coin::lbl_test})
is applied.}
}
\value{
A list with elements "methods" (character), "p.value" (matrix),
"plevel" (numeric), and "sign_colwise" (vector of length number of levels - 1)
}
\description{
\code{pairwise_ordcat_test} calculates pairwise comparisons for ordinal
categories between all group levels with corrections for multiple testing.
}
\examples{
# All pairwise comparisons
mtcars2 <- dplyr::mutate(mtcars, cyl = factor(cyl, ordered = TRUE))
pairwise_ordcat_test(dep_var = mtcars2$cyl, indep_var = mtcars2$gear)
# Only comparison against reference gear=3
pairwise_ordcat_test(dep_var = mtcars2$cyl, indep_var = mtcars2$gear, ref = TRUE)
}
