% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorePrefFrag.R
\name{scorePrefFrag}
\alias{scorePrefFrag}
\title{Identifcation and scoring of preferential cuting sites}
\usage{
scorePrefFrag(
  pepTab,
  useCol = c("seq", "precAA", "tailAA"),
  prefFragPat = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{pepTab}{(matrix) peptide-fragments with lines for peptides, cols as sequence/preceedingAA/tailingAA}

\item{useCol}{(character) column names for peptide-sequence,preceeding and tailing AA}

\item{prefFragPat}{(matrix) for preferential fragmentation rules (see \code{.prefFragPattern()})}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages and objects exportet to current session for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a matrix with fragment sequence, mass, start- and end-position, heading and tailing AA (or NA if terminal fragment)
}
\description{
Search for preferential fragmentation sites from 'pepTab' among the 3 colums specified via 'useCol' (for full AA sequence, preceeding AA, tailing AA) 
and return sum of scores (from 3rd column of prefFragPat) for both ends.
Note : proteins must be witten as single lettre code.
}
\examples{
pepT <- cbind(precAA=c("A","D","D","A","D"),seq=c("AKA","PKA","AKA","PKD","PKD"),
  tailAA=c("A","A","D","P","P"))
scorePrefFrag(pepT)
}
\seealso{
\code{\link{makeFragments}}
}
