% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseGroupNames.R
\name{chooseGroupNames}
\alias{chooseGroupNames}
\title{Choose Column Most Likely For Sample-Names}
\usage{
chooseGroupNames(
  mat,
  useCoNa = NULL,
  method = "median",
  sep = c("_", "-", " ", ".", "=", ";"),
  rmTxt = NULL,
  asUnique = TRUE,
  partEnumerator = FALSE,
  fullReport = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{mat}{(matrix or data.frame) contains possible choices for sample-names}

\item{useCoNa}{(character) optional custom choice for columns of \code{mat} to check; if \code{NULL} all columns will be used/checked}

\item{method}{(character) decide how to choose number of groups as : min, low, med, high, max or mode
Note arguments  \code{asUnique} and \code{partEnumerator} influence which columns of \code{mat} will be evaluated/checked}

\item{sep}{(character) separators considered when searching and removing common words}

\item{rmTxt}{(character, length=1) optional removing of custom text (eg variable file-extensions); no obligation that \code{rmTxt} occurs in all instances}

\item{asUnique}{(logical) requires all (potential) samples-names to be unique (ie no repeats) to be considered for group-names; also removes all candidate columns with all different names}

\item{partEnumerator}{(logical) when \code{TRUE} allows some instances of (potential) sample-names without numerator: a1, a2, b (ie some wo enumerator)}

\item{fullReport}{(logical) if \code{TRUE} returns list with $group, $sampleNames, $col (iondex of column from mat and name of c)}

\item{silent}{(logical) suppress messages if \code{TRUE}}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns a character vector with grouop-names (and sample-names as names of entries) or 
  if \code{fullReport=TRUE} a list with $group, $sampleNames, $col (index of column from \code{mat} and name of column
}
\description{
This function looks at all comumns of  \code{mat} which columns may be likely choices for sample-names and derives then group-names after stripping terminal enumerators.
Ideal sample-names should contain some replicates indicates as terminal enumerators.
}
\details{
The basic idea is that the column containing (good) samples-names contains all different entries and that by stripping terminal enumerators one can understand the grouping of replicates.
Note arguments  \code{asUnique} and \code{partEnumerator} influence which columns of \code{mat} will be evaluated/checked
}
\examples{
 mat <- cbind(a=letters[1:6], b=paste(rep(c("b","B"), each=3), 1:3), c=rep(1,6), 
   d=gl(3,2), e=rep(c("e","E"),3), f=paste(rep(c("F","f","ff"), each=2), 1:2))
chooseGroupNames(mat, method="median")         # col 2 (b/B)
chooseGroupNames(mat, method="median", fullReport=TRUE) 
chooseGroupNames(mat, method="min")            # col 2 (b/B)
chooseGroupNames(mat, method="max")            # col 6 (F/f/ff)
chooseGroupNames(mat, method="max", asUnique=FALSE) # col 1 (a..)
}
\seealso{
\code{\link{rmSharedWords}}, \code{\link{replicateStructure}}, \code{\link{protectSpecChar}}
}
