% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{store_rds}
\alias{store_rds}
\title{Store an RDS file in a workspace}
\usage{
store_rds(
  x,
  obj,
  filename,
  name = NULL,
  subdir,
  timestamp = format(Sys.time(), "\%Y-\%m-\%d \%H:\%M:\%S")
)
}
\arguments{
\item{x}{The workspace object.}

\item{obj}{The R object to save as an RDS file.}

\item{filename}{The name of the file used to store the RDS file in the workspace.}

\item{name}{name associated with the object, if a workspace file with this name exists
already it will be replaced.}

\item{subdir}{A subdirectory within the asset directory where the RDS file will be stored.}

\item{timestamp}{A timestamp string to associate with the entry in the workspace.}
}
\value{
Returns the \link{workspace} object passed to \code{x} parameter. Called primarily for side effects.
}
\description{
Saves an R object as an RDS file in an existing workspace.
This function allows users to save R objects in a workspace by serializing them as RDS files.
The RDS file is saved under the specified filename and organized within
a subdirectory for better structure. The timestamp parameter helps to keep track of when the file was stored.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_rds(
  x = z,
  obj = mtcars,
  filename = "obj.rds",
  timestamp = "2023-11-12 11:37:41",
  subdir = "r-object"
)
z
}
\seealso{
\link{workspace} for package documentation

Other functions to write in a workspace: 
\code{\link{delete_dataset}()},
\code{\link{store_dataset}()},
\code{\link{store_json}()},
\code{\link{store_raster}()},
\code{\link{store_yaml}()}
}
\concept{functions to write in a workspace}
