% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtools-page-api.R
\name{xtools_page}
\alias{xtools_page}
\alias{get_xtools_page_info}
\alias{get_xtools_page_prose}
\alias{get_xtools_page_links}
\alias{get_xtools_page_top_editors}
\alias{get_xtools_page_assessment}
\title{Access page-level statistics from the \href{https://www.mediawiki.org/wiki/XTools/API/Page}{XTools Page API endpoint}}
\usage{
get_xtools_page_info(title, language = "en", failure_mode = "error")

get_xtools_page_prose(
  title,
  language = "en",
  failure_mode = c("error", "quiet")
)

get_xtools_page_links(
  title,
  language = "en",
  failure_mode = c("error", "quiet")
)

get_xtools_page_top_editors(
  title,
  start = NULL,
  end = NULL,
  limit = 1000,
  nobots = FALSE,
  language = "en",
  failure_mode = c("error", "quiet")
)

get_xtools_page_assessment(
  title,
  classonly = FALSE,
  language = "en",
  failure_mode = c("error", "quiet")
)
}
\arguments{
\item{title}{Character vector of page titles}

\item{language}{Language code for the version of Wikipedia to query}

\item{failure_mode}{What to do if no data is found. See \code{\link[=get_rest_resource]{get_rest_resource()}}}

\item{start}{A character vector or date object (optional): the start date for
calculating top editors}

\item{end}{A character vector or date object (optional): the end date for
calculating top editors}

\item{limit}{An integer: the maximum number of top editors to return}

\item{nobots}{TRUE or FALSE: if TRUE, bots are excluded from the top editor
calculation}

\item{classonly}{TRUE or FALSE: if TRUE, only return the article's assessment
status, without Wikiproject information}
}
\value{
A list or tbl of results, the same length as \code{title}. \strong{NB:} The
results for \code{get_xtools_page_assessment} are still not parsed properly.
}
\description{
\code{get_xtools_page_info()} returns \href{https://www.mediawiki.org/wiki/XTools/API/Page#Article_info}{basic statistics}
about articles' history and quality, including their total edits, creation
date, and assessment value (good, featured etc.)

\code{get_xtools_page_prose()} returns \href{https://www.mediawiki.org/wiki/XTools/API/Page#Prose}{statistics about the word counts and referencing} of
articles

\code{get_xtools_page_links()} returns \href{https://www.mediawiki.org/wiki/XTools/API/Page#Links}{the number of ingoing and outgoing links to articles, including redirects}

\code{get_xtools_page_top_editors()} returns the \href{https://www.mediawiki.org/wiki/XTools/API/Page#Top_editors}{list of top editors for articles}, with
optional filters by date range and non-bot status

\code{get_xtools_page_assessment()} returns more detailed \href{https://www.mediawiki.org/wiki/XTools/API/Page#Assessments}{statistics about articles' assessment status and Wikiproject importance levels}
}
\examples{
# Get basic statistics about Erich Auerbach on German Wikipedia
auerbach <- get_xtools_page_info("Erich Auerbach", language = "de", failure_mode = "quiet")
auerbach
}
