% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator-query-type.R
\name{query_generate_pages}
\alias{query_generate_pages}
\alias{list_all_generators}
\title{Generate pages that meet certain criteria, or which are related to a set of
known pages by certain properties}
\usage{
query_generate_pages(.req, generator, ...)

list_all_generators()
}
\arguments{
\item{.req}{A httr2_request, e.g. generated by \code{wiki_action_request}}

\item{generator}{The generator module you wish to use. Most
\href{https://www.mediawiki.org/wiki/API:Lists}{list} and
\href{https://www.mediawiki.org/wiki/API:Properties}{property} modules can be
used, though not all.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Additional parameters to the
generator}
}
\value{
\link{query_generate_pages}: The modified request, which can be passed to \link{next_batch} or
\link{retrieve_all} as appropriate.

\link{list_all_generators}: a \link[tibble:tbl_df-class]{tibble} of all the available generator
modules. The \code{name} column gives the name of the generator, while the
\code{group} column indicates whether the generator is based on a list module
or a property module. Generators based on property modules can only be
added to a query if you have already used \link{query_by_} to specify which
pages' properties should be generated.
}
\description{
Many of the endpoints on the Action API can be used as \code{generators}. Use
\code{\link[=list_all_generators]{list_all_generators()}} to see a complete list. The main advantage of using a
generator is that you can chain it with calls to \code{\link[=query_page_properties]{query_page_properties()}} to
find out specific information about the pages. This is not possible for
queries constructed using \code{\link[=query_list_pages]{query_list_pages()}}.
}
\details{
There are two kinds of \code{generator}: list-generators and prop-generators. If
using a prop-generator, then you need to use a \code{\link[=query_by_]{query_by_()}} function to tell
the API where to start from, as shown in the examples.

To set additional parameters to a generator, prepend the parameter with "g".
For instance, to set a limit of 10 to the number of pages returned by the
\code{categorymembers} generator, set the parameter \code{gcmlimit = 10}.
}
\examples{
# Search for articles about seagulls
seagulls <- wiki_action_request() \%>\%
  query_generate_pages("search", gsrsearch = "seagull") \%>\%
  gracefully(next_batch)

seagulls
}
\seealso{
\code{\link[=gracefully]{gracefully()}}
}
