% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapfilling.R
\name{linear_fill}
\alias{linear_fill}
\title{Fill gaps by linear interpolation, or carrying forward or backward.}
\usage{
linear_fill(
  df,
  var,
  time_index,
  interpolate = TRUE,
  fill_forward = TRUE,
  fill_backward = TRUE,
  .by = NULL
)
}
\arguments{
\item{df}{A tibble data frame containing one observation per row.}

\item{var}{The variable of df containing gaps to be filled.}

\item{time_index}{The time index variable (usually year).}

\item{interpolate}{Logical. If \code{TRUE} (default),
performs linear interpolation.}

\item{fill_forward}{Logical. If \code{TRUE} (default),
carries last value forward.}

\item{fill_backward}{Logical. If \code{TRUE} (default),
carries first value backward.}

\item{.by}{A character vector with the grouping variables (optional).}
}
\value{
A tibble data frame (ungrouped) where gaps in var have been filled,
and a new "source" variable has been created indicating if the value is
original or, in case it has been estimated, the gapfilling method that has
been used.
}
\description{
Fills gaps (\code{NA} values) in a time-dependent variable by
linear interpolation between two points, or carrying forward or backwards
the last or initial values, respectively. It also creates a new variable
indicating the source of the filled values.
}
\examples{
sample_tibble <- tibble::tibble(
  category = c("a", "a", "a", "a", "a", "a", "b", "b", "b", "b", "b", "b"),
  year = c(
    "2015", "2016", "2017", "2018", "2019", "2020",
    "2015", "2016", "2017", "2018", "2019", "2020"
  ),
  value = c(NA, 3, NA, NA, 0, NA, 1, NA, NA, NA, 5, NA),
)
linear_fill(sample_tibble, value, year, .by = c("category"))
linear_fill(
  sample_tibble,
  value,
  year,
  interpolate = FALSE,
  .by = c("category"),
)
}
