% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wex.R
\name{wex}
\alias{wex}
\title{Exact observation weights for the Kalman filter and smoother.}
\usage{
wex(a0 = NULL, P0 = NULL, Tt, Zt, HHt, GGt, yt, t)
}
\arguments{
\item{a0}{A \code{vector} giving the initial value/estimation of the state variable. By default is set to zero.}

\item{P0}{A \code{matrix} giving the variance of a0. By default is a diagonal matrix of 10^6.}

\item{Tt}{An \code{array} giving the factor of the transition equation (see \bold{Details}).}

\item{Zt}{An \code{array} giving the factor of the measurement equation (see \bold{Details}).}

\item{HHt}{An \code{array} giving the variance of the innovations of the transition equation (see \bold{Details}).}

\item{GGt}{An \code{array} giving the variance of the disturbances of the measurement equation (see \bold{Details}).}

\item{yt}{An \eqn{n \times d}{n * d} matrix, where d is the dimension and n is the number of observations. \code{matrix} containing the observations. “NA”-values are allowed (see \bold{Details}).}

\item{t}{An observation index for which the weights are returned.}
}
\value{
Weight matrices for filtering (Wt) and smoothing (WtT).
}
\description{
This function computes the exact observation weights for the Kalman filter and smoother,
as described by Koopman and Harvey (2003). The implementation of \code{wex} builds upon the
existing \code{FKF} package (see: https://CRAN.R-project.org/package=FKF).
}
\details{
\strong{State space form}

\deqn{\alpha_{t+1} = T_t \alpha_t + H_t \eta_t,}
\deqn{y_t = Z_t \alpha_t + G_t \epsilon_t,}

where \eqn{y_t} represents the observed data (possibly with NA's),
and \eqn{\alpha_t} is the state vector.
}
\examples{

# Decompose a local level model (Nile data set)
data(Nile)
y <- Nile
wts <- wex(Tt=matrix(1),
Zt=matrix(1),
HHt = matrix(1385.066),
GGt = matrix(15124.13),
yt = t(y),
t=50)





}
\references{
Koopman, S. J., & Harvey, A. (2003). Computing observation weights for
signal extraction and filtering. \emph{Journal of Economic Dynamics and Control}, \bold{27}(7), 1317-1333.
}
