% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedCox.R
\name{cox_rhogamma_resample}
\alias{cox_rhogamma_resample}
\title{Resampling for Weighted Cox Model (rho, gamma)}
\usage{
cox_rhogamma_resample(
  fit_rhogamma,
  i_bhat,
  K_wt_rg,
  i_zero,
  K_zero,
  G1.draws = NULL,
  G0.draws = NULL,
  draws = 100,
  seedstart = 8316951
)
}
\arguments{
\item{fit_rhogamma}{List with fitted Cox model results.}

\item{i_bhat}{Information at estimated beta.}

\item{K_wt_rg}{Weights at estimated beta.}

\item{i_zero}{Information at beta=0.}

\item{K_zero}{Weights at beta=0.}

\item{G1.draws}{Optional: pre-generated random draws for groups.}

\item{G0.draws}{Optional: pre-generated random draws for groups.}

\item{draws}{Number of resampling iterations (default: 100).}

\item{seedstart}{Random seed for reproducibility (default: 8316951).}
}
\value{
List with resampling results (score, beta, standard error, etc.).
}
\description{
Performs resampling to estimate uncertainty for the weighted Cox model (rho, gamma).
}
