% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmplotting_helpers.R
\name{KM_plot_2sample_weighted_counting}
\alias{KM_plot_2sample_weighted_counting}
\title{Plot Weighted Kaplan-Meier Curves for Two Samples (Counting Process Format)}
\usage{
KM_plot_2sample_weighted_counting(
  dfcount,
  show.cox = TRUE,
  cox.cex = 0.725,
  show.logrank = FALSE,
  logrank.cex = 0.725,
  cox.eps = 0.001,
  lr.eps = 0.001,
  show_arm_legend = TRUE,
  arms = c("treat", "control"),
  put.legend.arms = "left",
  stop.onerror = TRUE,
  check.KM = TRUE,
  put.legend.cox = "topright",
  put.legend.lr = "topleft",
  lr.digits = 2,
  cox.digits = 2,
  tpoints.add = c(0),
  by.risk = NULL,
  Xlab = "time",
  Ylab = "proportion surviving",
  col.0 = "black",
  col.1 = "blue",
  show.med = TRUE,
  med.digits = 2,
  med.font = 4,
  conf.int = FALSE,
  conf_level = 0.95,
  choose_ylim = FALSE,
  arm.cex = 0.7,
  quant = 0.5,
  med.cex = 0.725,
  ymed.offset = 0.1,
  xmed.fraction = 0.8,
  risk.cex = 0.725,
  ltys = c(1, 1),
  lwds = c(1, 1),
  censor.mark.all = TRUE,
  censor.cex = 0.5,
  show.ticks = TRUE,
  risk.set = TRUE,
  ymin = 0,
  ymax = 1,
  ymin.del = 0.035,
  ymin2 = NULL,
  risk_offset = 0.125,
  risk_delta = 0.05,
  y.risk0 = NULL,
  show.Y.axis = TRUE,
  cex_Yaxis = 1,
  y.risk1 = NULL,
  add.segment = FALSE,
  risk.add = NULL,
  xmin = 0,
  xmax = NULL,
  x.truncate = NULL,
  time.zero = 0,
  prob.points = NULL
)
}
\arguments{
\item{dfcount}{List containing precomputed survival data.}

\item{show.cox}{Logical; show Cox model results.}

\item{cox.cex}{Numeric; text size for Cox annotation.}

\item{show.logrank}{Logical; show log-rank test results.}

\item{logrank.cex}{Numeric; text size for log-rank annotation.}

\item{cox.eps}{Numeric; small values for Cox calculations.}

\item{lr.eps}{Numeric; small values for log-rank calculations.}

\item{show_arm_legend}{Logical; show arm legend.}

\item{arms}{Character vector of arm labels.}

\item{put.legend.arms}{Character; legend positions.}

\item{stop.onerror}{Logical; stop on KM curve errors.}

\item{check.KM}{Logical; check KM curve validity.}

\item{put.legend.cox}{Character; legend positions.}

\item{put.legend.lr}{Character; legend positions.}

\item{lr.digits}{Integer; digits for test results.}

\item{cox.digits}{Integer; digits for test results.}

\item{tpoints.add}{Numeric vector; additional time points to include (default: c(0)).}

\item{by.risk}{Numeric; interval for risk table time points.}

\item{Xlab}{Character; axis labels.}

\item{Ylab}{Character; axis labels.}

\item{col.0}{Color for control curve.}

\item{col.1}{Color for treatment curve.}

\item{show.med}{Logical; annotate median survival.}

\item{med.digits}{Median annotation settings.}

\item{med.font}{Median annotation settings.}

\item{conf.int}{Logical; plot confidence intervals.}

\item{conf_level}{Numeric; confidence level for intervals.}

\item{choose_ylim}{Logical; auto-select y-axis limits.}

\item{arm.cex}{Numeric; text size for arm legend.}

\item{quant}{Numeric; quantile for annotation.}

\item{med.cex}{Median annotation settings.}

\item{ymed.offset}{Median annotation settings.}

\item{xmed.fraction}{Median annotation settings.}

\item{risk.cex}{Numeric; text size for risk table.}

\item{ltys}{Integer; line types for curves.}

\item{lwds}{Integer; line widths for curves.}

\item{censor.mark.all}{Logical; mark all censored times.}

\item{censor.cex}{Numeric; size of censor marks.}

\item{show.ticks}{Logical; show axis ticks.}

\item{risk.set}{Logical; display risk table.}

\item{ymin}{Additional graphical and calculation parameters.}

\item{ymax}{Additional graphical and calculation parameters.}

\item{ymin.del}{Additional graphical and calculation parameters.}

\item{ymin2}{Additional graphical and calculation parameters.}

\item{risk_offset}{Additional graphical and calculation parameters.}

\item{risk_delta}{Additional graphical and calculation parameters.}

\item{y.risk0}{Additional graphical and calculation parameters.}

\item{show.Y.axis}{Additional graphical and calculation parameters.}

\item{cex_Yaxis}{Additional graphical and calculation parameters.}

\item{y.risk1}{Additional graphical and calculation parameters.}

\item{add.segment}{Additional graphical and calculation parameters.}

\item{risk.add}{Additional graphical and calculation parameters.}

\item{xmin}{Additional graphical and calculation parameters.}

\item{xmax}{Additional graphical and calculation parameters.}

\item{x.truncate}{Additional graphical and calculation parameters.}

\item{time.zero}{Numeric; time zero value for risk table alignment (default: 0).}

\item{prob.points}{Numeric vector; probability points for additional annotations (default: NULL).}
}
\value{
Invisibly returns NULL. Used for plotting side effects.
}
\description{
Plots Kaplan-Meier survival curves for two groups using precomputed risk/event counts and survival estimates.
Optionally displays confidence intervals, risk tables, median survival annotations, and statistical test results.
}
