% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dpird_extremes.R
\name{get_dpird_extremes}
\alias{get_dpird_extremes}
\title{Get DPIRD Extreme Weather Event Summaries}
\usage{
get_dpird_extremes(
  station_code,
  values = "all",
  api_key = get_key(service = "DPIRD")
)
}
\arguments{
\item{station_code}{A \code{character} string or \code{factor} from
\code{\link[=get_stations_metadata]{get_stations_metadata()}} of the \acronym{BOM} station code for the station
of interest.}

\item{values}{A \code{character} string with the type of extreme weather to
return.  See \strong{Available Values} for a full list of valid values.
Defaults to \code{all}, returning the full list of values unless otherwise
specified.}

\item{api_key}{A \code{character} string containing your \acronym{API} key from
\acronym{DPIRD}, \url{https://www.dpird.wa.gov.au/online-tools/apis/}, for the
\acronym{DPIRD} Weather 2.0 \acronym{API}.  Defaults to automatically
detecting your key from your local .Renviron, .Rprofile or similar.
Alternatively, you may directly provide your key as a string here.  If
nothing is provided, you will be prompted on how to set up your \R session
so that it is auto-detected.}
}
\value{
a \code{\link[data.table:data.table]{data.table::data.table()}} of one row with \code{station_code},
\code{station_name}, \code{latitude}, \code{longitude}, \code{date_time} of the query and the
extreme weather information according to the value(s) selected.
}
\description{
Fetch nicely formatted individual extreme weather summaries from the
\acronym{DPIRD} Weather 2.0 \acronym{API}.
}
\section{Available Values}{

\itemize{
\item all (which will return all of the following values),
\item erosionCondition,
\item erosionConditionLast7Days,
\item erosionConditionLast7DaysDays,
\item erosionConditionLast7DaysMinutes,
\item erosionConditionLast14Days,
\item erosionConditionLast14DaysDays,
\item erosionConditionLast14DaysMinutes,
\item erosionConditionMonthToDate,
\item erosionConditionMonthToDateDays,
\item erosionConditionMonthToDateMinutes,
\item erosionConditionMonthToDateStartTime,
\item erosionConditionSince12AM,
\item erosionConditionSince12AMMinutes,
\item erosionConditionSince12AMStartTime,
\item erosionConditionYearToDate,
\item erosionConditionYearToDateDays,
\item erosionConditionYearToDateMinutes,
\item erosionConditionYearToDateStartTime,
\item frostCondition,
\item frostConditionLast7Days,
\item frostConditionLast7DaysDays,
\item frostConditionLast7DaysMinutes,
\item frostConditionLast14Days,
\item frostConditionLast14DaysDays,
\item frostConditionLast14DaysMinutes,
\item frostConditionMonthToDate,
\item frostConditionMonthToDateDays,
\item frostConditionMonthToDateMinutes,
\item frostConditionMonthToDateStartTime,
\item frostConditionSince9AM,
\item frostConditionSince9AMMinutes,
\item frostConditionSince9AMStartTime,
\item frostConditionTo9AM,
\item frostConditionTo9AMMinutes,
\item frostConditionTo9AMStartTime,
\item frostConditionYearToDate,
\item frostConditionYearToDate,
\item frostConditionYearToDateMinutes,
\item frostConditionYearToDateStartTime,
\item heatCondition,
\item heatConditionLast7Days,
\item heatConditionLast7DaysDays,
\item heatConditionLast7DaysMinutes,
\item heatConditionLast14Days,
\item heatConditionLast14DaysDays,
\item heatConditionLast14DaysMinutes,
\item heatConditionMonthToDate,
\item heatConditionMonthToDateDays,
\item heatConditionMonthToDateMinutes,
\item heatConditionMonthToDateStartTime,
\item heatConditionSince12AM,
\item heatConditionSince12AMMinutes,
\item heatConditionSince12AMStartTime,
\item heatConditionYearToDate,
\item heatConditionYearToDateDays,
\item heatConditionYearToDateMinutes, and
\item heatConditionYearToDateStartTime
}
}

\examples{
\dontrun{
# Query Bonnie Rock station for wind erosion and heat extreme events
# Note that you need to supply your own API key

xtreme <- get_dpird_extremes(
  station_code = "BR",
  values = c("erosionCondition",
           "heatCondition"),
  api_key = "your_api_key"
)
}

}
\seealso{
Other DPIRD: 
\code{\link{dpird_extreme_weather_values}},
\code{\link{dpird_minute_values}},
\code{\link{dpird_summary_values}},
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_availability}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_stations_metadata}()}

Other data fetching: 
\code{\link{get_ag_bulletin}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_data_drill}()},
\code{\link{get_data_drill_apsim}()},
\code{\link{get_dpird_apsim}()},
\code{\link{get_dpird_minute}()},
\code{\link{get_dpird_summaries}()},
\code{\link{get_patched_point}()},
\code{\link{get_patched_point_apsim}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{get_satellite_imagery}()}
}
\author{
Rodrigo Pires, \email{rodrigo.pires@dpird.wa.gov.au}, and Adam
Sparks, \email{adamhsparks@gmail.com}
}
\concept{DPIRD}
\concept{data fetching}
