% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_satellite_imagery.R
\name{get_available_imagery}
\alias{get_available_imagery}
\title{Get a List of Available BOM Satellite Imagery}
\usage{
get_available_imagery(product_id = "all")
}
\arguments{
\item{product_id}{\code{Character}. \acronym{BOM} product \acronym{ID} of interest
for which a list of available images will be returned.  Defaults to all
images currently available.}
}
\value{
A \code{vector} of all available files for the requested Product ID(s).
}
\description{
Fetch a listing of \acronym{BOM} GeoTIFF satellite imagery from
\url{ftp://ftp.bom.gov.au/anon/gen/gms/} to determine which files are
currently available for download.  Files are available at ten minute update
frequency with a 24-hour delete time.  It is useful to know the most recent
files available and then specify in the \code{\link[=get_satellite_imagery]{get_satellite_imagery()}}
function.  Ported from \CRANpkg{bomrang}.
}
\details{
Valid \acronym{BOM} satellite Product IDs for GeoTIFF files
include:
\describe{
\item{IDE00420}{AHI cloud cover only 2km FD GEOS GIS}
\item{IDE00421}{AHI IR (Ch13) greyscale 2km FD GEOS GIS}
\item{IDE00422}{AHI VIS (Ch3) greyscale 2km FD GEOS GIS}
\item{IDE00423}{AHI IR (Ch13) Zehr 2km FD GEOS GIS}
\item{IDE00425}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km
FD GEOS GIS}
\item{IDE00426}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 2km
FD GEOS GIS}
\item{IDE00427}{AHI WV (Ch8) 2km FD GEOS GIS}
\item{IDE00430}{AHI cloud cover only 2km AUS equirect. GIS}
\item{IDE00431}{AHI IR (Ch13) greyscale 2km AUS equirect. GIS}
\item{IDE00432}{AHI VIS (Ch3) greyscale 2km AUS equirect. GIS}
\item{IDE00433}{AHI IR (Ch13) Zehr 2km AUS equirect. GIS}
\item{IDE00435}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 1km
AUS equirect. GIS}
\item{IDE00436}{AHI VIS (true colour) / IR (Ch13 greyscale) composite 2km
AUS equirect. GIS}
\item{IDE00437}{AHI WV (Ch8) 2km AUS equirect. GIS}
\item{IDE00439}{AHI VIS (Ch3) greyscale 0.5km AUS equirect. GIS}
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check availability of AHI VIS (true colour) / IR (Ch13 greyscale) composite
# 1km FD GEOS GIS images
imagery <- get_available_imagery(product_id = "IDE00425")

imagery
\dontshow{\}) # examplesIf}
}
\references{
Australian Bureau of Meteorology (\acronym{BOM}) high-definition satellite
images \url{http://www.bom.gov.au/australia/satellite/index.shtml}
}
\seealso{
Other BOM: 
\code{\link{find_forecast_towns}()},
\code{\link{get_ag_bulletin}()},
\code{\link{get_available_radar}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{get_satellite_imagery}()},
\code{\link{parse_ag_bulletin}()},
\code{\link{parse_coastal_forecast}()},
\code{\link{parse_precis_forecast}()}

Other metadata: 
\code{\link{find_forecast_towns}()},
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_available_radar}()},
\code{\link{get_dpird_availability}()},
\code{\link{get_stations_metadata}()}
}
\author{
Adam H. Sparks, \email{adamhsparks@gmail.com}
}
\concept{BOM}
\concept{metadata}
