% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-station_observations.R
\name{station_obs}
\alias{station_obs}
\title{Station Observations}
\usage{
station_obs(station_id, timezone = -1, dir_numeric = FALSE)
}
\arguments{
\item{station_id}{The station identifier (ex: KDEN, KBOS, KNYC, etc).}

\item{timezone}{The nominal timezone for the forecast. One of \code{OlsonNames()} or \code{-1} for local time. Defaults to \code{-1}.}

\item{dir_numeric}{\code{TRUE} for numeric directions, \code{FALSE} for character directions; defaults to \code{FALSE}.}
}
\value{
Simple features corresponding to the given station identifier with recent meteorological observations.
}
\description{
Station Observations
}
\examples{
\donttest{
station_obs("KBOS") \%>\% data.frame() \%>\%
  dplyr::select(-geometry) \%>\%
  dplyr::filter(temp == max(.$temp))
}
}
