% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nowatch.R
\name{read_nowatch}
\alias{read_nowatch}
\title{Read Nowatch data}
\usage{
read_nowatch(zipfile = NULL, folder = NULL, tz = Sys.timezone())
}
\arguments{
\item{zipfile}{A zip file as exported by the instrument. Only aggregated data supported.}

\item{folder}{A folder with the unzipped files. If this is provided, the zipfile is not used.}

\item{tz}{The timezone used by the instrument (defaults to user timezone).}
}
\description{
Reads in Nowatch data as a list, and prepends timecolumns
}
\details{
This function reads in a zipfile with files exported by the Nowatch instrument,
or a folder with the unzipped files. The files are expected to be csv files.

The unzipped files are csv files.

The function returns an object of class "nowatchdata" with a prepended datetime columns.
The object contains a list with dataframes from the physiological signals.
}
\examples{
\dontrun{
 library(wearables)
 read_nowatch("yourpathtohezipfile.zip")
 read_nowatch(folder = "/path/to/folder/with/files")
}
}
