% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wave.R
\name{wave}
\alias{wave}
\title{Access WebAIM WAVE Accessibility API}
\usage{
wave(
  key,
  url,
  format = NULL,
  viewportwidth = NULL,
  reporttype = NULL,
  username = NULL,
  password = NULL,
  useragent = NULL,
  toDataframe = FALSE,
  file = NULL
)
}
\arguments{
\item{key}{Character string. Your WAVE API key}

\item{url}{Character string. URL of the webpage to analyze}

\item{format}{Character string. Response format (optional)}

\item{viewportwidth}{Integer. Viewport width for analysis (optional)}

\item{reporttype}{Integer. Type of report to generate (1-4) (optional)}

\item{username}{Character string. Username for protected pages (optional)}

\item{password}{Character string. Password for protected pages (optional)}

\item{useragent}{Character string. Custom user agent (optional)}

\item{toDataframe}{Logical. Whether to convert results to a data frame (default: FALSE)}

\item{file}{Character string. Optional file path to save JSON results}
}
\value{
List or tibble containing WAVE analysis results
}
\description{
This function provides an interface to the WebAIM WAVE accessibility evaluation API.
It allows you to analyze web pages for accessibility issues and retrieve detailed reports.
}
\examples{
\dontrun{
# Basic usage
results <- wave(key = "your_api_key", url = "https://example.com")

# Get results as a data frame
df_results <- wave(key = "your_api_key", url = "https://example.com", toDataframe = TRUE)

# Save results to a temporary file
tmp_file <- file.path(tempdir(), "wave_results.json")
wave(key = "your_api_key", url = "https://example.com", file = tmp_file)
}
}
