% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.actor.mastodon.R
\name{Create.actor.mastodon}
\alias{Create.actor.mastodon}
\title{Create mastodon actor network}
\usage{
\method{Create}{actor.mastodon}(
  datasource,
  type,
  subtype = NULL,
  inclMentions = TRUE,
  ...,
  writeToFile = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"mastodon"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"actor"}.}

\item{subtype}{Character string. Subtype of actor network to be created. Can be set to \code{"server"}. Default is
\code{NULL}.}

\item{inclMentions}{Logical. Create edges for users mentioned or tagged in posts. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}

\item{writeToFile}{Logical. Write data to file. Default is \code{FALSE}.}

\item{verbose}{Logical. Output additional information. Default is \code{TRUE}.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates a mastodon actor network from posts. Mastodon users who have posted are actor nodes. The
created network is directed with edges representing replies.
}
\examples{
\dontrun{
# create a mastodon actor network
actor_net <- mastodon_data |> Create("actor")

# create a mastodon server relations network
actor_net <- mastodon_data |> Create("actor", "server")
}

}
