% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_calc.R
\name{calc_pc}
\alias{calc_pc}
\title{Calculate Profit Commission for Reinsurance}
\usage{
calc_pc(PREM, CLAIM, pc_rate, me, loss_carry, duration)
}
\arguments{
\item{PREM}{Numeric vector of premiums.}

\item{CLAIM}{Numeric vector of claims.}

\item{pc_rate}{Profit commission rate (typically between 0 and 1).}

\item{me}{Administrative expense rate deducted from premium (typically between 0 and 1).}

\item{loss_carry}{Whether to apply loss carryforward across periods. Must be "Y" (yes) or "N" (no).}

\item{duration}{Numeric vector of durations. Must match length of PREM and CLAIM and be consecutive integers.}
}
\value{
A numeric vector of calculated profit commissions (same length as duration).
}
\description{
Calculates profit commission payouts for a single set of reinsurance cash flows.

This function supports standard profit commission rules using input cash flows and applies key parameters
such as the profit commission rate, administrative expense rate, and loss carryforward logic.
}
\examples{
# Simple numeric vectors
PREM <- c(1000, 1000, 1000, 1000, 1000, 1000)
CLAIM <- c(600, 1800, 600, 600, 600, 600)
duration <- 1:6
calc_pc(PREM, CLAIM, pc_rate = 0.9, me = 0.05, loss_carry = "Y", duration = duration)

# Using example_simulation dataset
example_simulation_with_PC <- example_simulation \%>\%
  dplyr::group_by(split, sim_n) \%>\%
  dplyr::mutate(
  PC = calc_pc(PREM,
               CLAIM,
               pc_rate = 0.9,
               me = 0.05,
               loss_carry = "N",
               duration = DURATION)) \%>\%
  dplyr::ungroup()
}
