% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ktdb.R
\name{read_ktdb_files}
\alias{read_ktdb_files}
\title{Read old-age mortality data from files downloaded from K-T database}
\usage{
read_ktdb_files(male = NULL, female = NULL, triangle = 1)
}
\arguments{
\item{male}{File containing male mortality downloaded from the K-T database.}

\item{female}{File containing female mortality downloaded from the K-T database.}

\item{triangle}{Lexis triangle number, 1 (default) is lower triangle, 2 is upper triangle.}
}
\value{
\code{read_ktdb_files} returns a \code{vital} object combining the downloaded data.
}
\description{
\code{read_ktdb_files} reads old-age mortality data from files downloaded from
K-T database (\url{https://www.demogr.mpg.de/cgi-bin/databases/ktdb/datamap.plx})
and constructs a \code{vital} object suitable for use in other functions.
If two files are provided, the function will treat them as data for each gender,
returning a combined dataset. If only one file is provided, the function will
assume that it represents data for a single gender.
}
\examples{
\dontrun{
# File downloaded from the K-T database
australia_male <- read_ktdb_files("maustl.txt")
}

}
\author{
Sixian Tang
}
