% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitped.R
\name{splitped}
\alias{splitped}
\title{Split Pedigree into Disconnected Groups}
\usage{
splitped(ped)
}
\arguments{
\item{ped}{A tidyped object created by \code{\link{tidyped}}.}
}
\value{
A list of class "splitped" containing:
  \item{GP1, GP2, ...}{tidyped objects for each disconnected group (with at least
    2 individuals), with renumbered IndNum, SireNum, DamNum}

  The returned object has the following attributes:
  \item{n_groups}{Number of disconnected groups found (excluding isolated individuals)}
  \item{sizes}{Named vector of group sizes}
  \item{total}{Total number of individuals in groups (excluding isolated)}
  \item{isolated}{Character vector of isolated individual IDs (Gen = 0)}
  \item{n_isolated}{Number of isolated individuals}
}
\description{
Detects and splits a tidyped object into disconnected groups (connected components).
Uses igraph to efficiently find groups of individuals that have no genetic
relationships with each other. Isolated individuals (Gen = 0, those with no
parents and no offspring) are excluded from group splitting and stored separately.
}
\details{
This function identifies connected components in the pedigree graph where
edges represent parent-offspring relationships. Two individuals are in the
same group if they share any ancestry (direct or indirect).

Isolated individuals (Gen = 0 in tidyped output) are those who:
\itemize{
  \item Have no known parents (Sire and Dam are both NA)
  \item Are not parents of any other individual in the pedigree
}
These isolated individuals are excluded from splitting and stored in the
\code{isolated} attribute. Each resulting group contains at least 2 individuals
(at least one parent-offspring relationship).

The function always returns a list, even if there is only one group (i.e.,
the pedigree is fully connected). Groups are sorted by size in descending
order.

Each group in the result is a valid tidyped object with:
\itemize{
  \item Renumbered IndNum (1 to n for each group)
  \item Updated SireNum and DamNum referencing the new IndNum
  \item Recalculated Gen (generation) based on the group's structure
}
}
\examples{
# Load example data
library(visPedigree)
data(small_ped)

# First tidy the pedigree
tped <- tidyped(small_ped)

# Split into groups
result <- splitped(tped)
print(result)

# Access individual groups (each is a tidyped object)
result$GP1

# Check isolated individuals
attr(result, "isolated")

}
\seealso{
\code{\link{tidyped}} for pedigree tidying
}
