% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_domain_info.R
\name{get_domain_info}
\alias{get_domain_info}
\title{Retrieve information about an Internet domain}
\usage{
get_domain_info(domain = NULL, limit = NULL, cursor = NULL, ...)
}
\arguments{
\item{domain}{domain name. String. Required.}

\item{limit}{Number of entries. Integer. Optional.  Default is 10.}

\item{cursor}{String. Optional.}

\item{\dots}{Additional arguments passed to \code{\link{virustotal_GET}}.}
}
\value{
named list
}
\description{
Retrieve information about an Internet domain
}
\examples{
\dontrun{

# Before calling the function, set the API key using set_key('api_key_here')
   
get_domain_info("http://www.google.com")
get_domain_info("http://www.goodsfwrfw.com") # Domain not found
}
}
\references{
\url{https://docs.virustotal.com/reference}
}
\seealso{
\code{\link{set_key}} for setting the API key
}
