% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riemann_rectangles2d.R
\name{riemann_rectangles2d}
\alias{riemann_rectangles2d}
\title{Animate Riemann rectangles under a curve (2D)}
\usage{
riemann_rectangles2d(
  f,
  a,
  b,
  n_vals = NULL,
  method = c("midpoint", "left", "right"),
  n_curve = 400L,
  frame_ms = 900L,
  transition_ms = 0L,
  title = NULL,
  show_sum = TRUE,
  y0 = 0
)
}
\arguments{
\item{f}{Function. A real-valued function. It must accept a numeric vector
and return a numeric vector of the same length.}

\item{a}{Numeric scalar. Left endpoint.}

\item{b}{Numeric scalar. Right endpoint. Must satisfy b > a.}

\item{n_vals}{Integer vector. Values of the number of subintervals used as
animation frames. If NULL, a default increasing sequence is used.}

\item{method}{Character. Rule used for rectangle heights: "midpoint"
(default), "left", or "right".}

\item{n_curve}{Integer. Number of points used to draw the base curve.}

\item{frame_ms}{Integer. Frame duration in milliseconds.}

\item{transition_ms}{Integer. Transition duration in milliseconds.}

\item{title}{Character. Plot title. If NULL, a default title is used.}

\item{show_sum}{Logical. If TRUE, show n and the value of the Riemann sum in
hover text.}

\item{y0}{Numeric scalar. Baseline for rectangles (default 0).}
}
\value{
A plotly object (htmlwidget) with animation frames.
}
\description{
Builds an interactive Plotly animation of Riemann sums approximating the
area under a function on a closed interval.
}
\examples{
\donttest{
library(plotly)
f <- function(x) x^2
riemann_rectangles2d(f, 0, 1)
}

}
