% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.meanratio2}
\alias{se.meanratio2}
\title{Computes the standard error for a 2-group log mean ratio}
\usage{
se.meanratio2(m1, m2, sd1, sd2, n1, n2)
}
\arguments{
\item{m1}{estimated mean for group 1}

\item{m2}{estimated mean for group 2}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimated log mean ratio
\item SE - standard error
}
}
\description{
Computes the standard error of a 2-group log mean ratio using the
estimated means, estimated standard deviations, and sample sizes.
The log mean estimate and standard error output from this function
can be used as input in the \link[vcmeta]{meta.ave.gen},
\link[vcmeta]{meta.lc.gen}, and \link[vcmeta]{meta.lm.gen} functions
in application where compatible mean ratios from a combination of
2-group and paired-samples experiments are used in the meta-analysis.
Equality of variances is not assumed.
}
\examples{
se.meanratio2(21.9, 16.1, 3.82, 3.21, 40, 40)

# Should return:
#                   Estimate       SE
# Log mean ratio:  0.3076674 0.041886


}
\references{
\insertRef{Bonett2020}{vcmeta}
}
