% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_ave.R
\name{meta.ave.cor.gen}
\alias{meta.ave.cor.gen}
\title{Confidence interval for an average correlation of any type}
\usage{
meta.ave.cor.gen(alpha, cor, se, bystudy = TRUE)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor}{vector of estimated correlations}

\item{se}{vector of standard errors}

\item{bystudy}{logical to also return each study estimate (TRUE) or not}
}
\value{
Returns a matrix.  The first row is the average estimate across all studies.  If bystudy
is TRUE, there is 1 additional row for each study.  The matrix has the following columns:
\itemize{
\item Estimate - estimated effect size
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes the estimate, standard error, and confidence interval for an
average correlation. Any type of correlation can be used (e.g., Pearson,
Spearman, semipartial, factor correlation, gamma coefficient, Somers d
coefficient, tetrachoric, point-biserial, biserial, correlation between
latent factors, etc.).
}
\examples{
cor <- c(.396, .454, .409, .502, .350)
se <- c(.104, .064, .058, .107, .086)
meta.ave.cor.gen(.05, cor, se, bystudy = TRUE)

# Should return:
#         Estimate         SE        LL        UL
# Average   0.4222 0.03853362 0.3438560 0.4947070
# Study 1   0.3960 0.10400000 0.1753200 0.5787904
# Study 2   0.4540 0.06400000 0.3200675 0.5701415
# Study 3   0.4090 0.05800000 0.2893856 0.5160375
# Study 4   0.5020 0.10700000 0.2651183 0.6817343
# Study 5   0.3500 0.08600000 0.1716402 0.5061435


}
\references{
\insertRef{Bonett2008a}{vcmeta}
}
