% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_calculators.R
\name{calc_expected_infections}
\alias{calc_expected_infections}
\title{Calculate the expected number of infections in a cohort}
\usage{
calc_expected_infections(vc, disease, kindergarten_size, VE, r0_custom = NULL)
}
\arguments{
\item{vc}{Vaccination coverage rate (proportion, 0 to 1).}

\item{disease}{Character string: "Measles", "Pertussis", "Chickenpox", or "Custom".}

\item{kindergarten_size}{Integer, the size of the school cohort.}

\item{VE}{Vaccine effectiveness (proportion, 0 to 1).}

\item{r0_custom}{The basic reproduction number (R0) for a custom disease.
Required only if `disease` is "Custom".}
}
\value{
The expected number of infected individuals.
}
\description{
Calculate the expected number of infections in a cohort
}
\examples{
calc_expected_infections(vc = 0.85, disease = "Measles", kindergarten_size = 200, VE = 0.97)
calc_expected_infections(
  vc = 0.90, disease = "Custom", kindergarten_size = 150, VE = 0.90, r0_custom = 7
)
}
