% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUCuniform.R
\encoding{UTF-8}
\name{AUCuniform}
\alias{AUCuniform}
\title{Calculates the uniform \emph{AUC} and uniform \emph{Se*}}
\usage{
AUCuniform(
  mat,
  rep = 100,
  by = 0.1,
  deleteBins = NULL,
  plot = FALSE,
  plot.adds = FALSE
)
}
\arguments{
\item{mat}{A matrix with two columns. The first column must contain the
suitability values (i.e., the classification rule); the second column must
contain the presences and absences.}

\item{rep}{Number of sampling replications. By default, \code{rep} = 100.}

\item{by}{Size of the suitability intervals (i.e., bins). By default,
\code{by} = 0.1.}

\item{deleteBins}{A vector (e.g., from 1 to 10 if \code{by} = 0.1) with the
bins that have to be excluded (1 for [0,0.1), 10 for [0.9,1]) from the
resampling procedure (trimming); \code{NULL} by default.}

\item{plot}{Logical. Indicates whether or not the observed ROC curve is
plotted.}

\item{plot.adds}{Logical. Indicates whether or not the negative diagonal and
the point of equivalence are added to the observed ROC plot.}
}
\value{
A list with the following elements:

\code{AUC}: the \emph{AUC} value (non-uniform), a numeric value 
between 0 and 1.

\code{Se}: the \emph{Se*} value (non-uniform), a numeric value 
between 0 and 1.

\code{bins}: a table with the sample size of each bin.

\code{suit.sim}: a matrix with the bootstrapped suitability values.

\code{sp.sim}: a matrix with the bootstrapped presence-absence data.

\code{uAUC}: a numeric vector with the (\emph{uAUC}) values for each
replication.

\code{uAUC.95CI}: a numeric vector with the sample (\emph{uAUC}) 
quantiles corresponding to the probabilities 0.025, 0.5 and 0.975.

\code{uSe}: a numeric vector with the (\emph{uSe*}) values for each
replication.

\code{uSe.95CI}: a numeric vector with the sample (\emph{uSe*}) 
quantiles corresponding to the probabilities 0.025, 0.5 and 0.975.
}
\description{
This function computes the uniform \emph{AUC} (\emph{uAUC}) and
uniform \emph{Se*} (\emph{uSe*}) following Jiménez-Valverde (2022). A revised 
and improved formulation is available in \code{\link{AUCuniform.2}}, which 
users are encouraged to consider for most applications.
}
\details{
This function performs the stratified weighted bootstrap to
calculate the uniform \emph{AUC} (\emph{uAUC}) and uniform \emph{Se*}
(\emph{uSe*}) as suggested in Jiménez-Valverde (2022).  A warning message
will be shown if the sample size of any bin is zero. Another warning message
will be shown if the sample size of any bin is lower than 15. In such case,
trimming should be considered. The \emph{AUC} (non-uniform) is estimated
non-parametrically (Bamber 1975). \emph{Se*} is calculated by selecting the
point that minimizes the absolute difference between sensitivity and
specificity and by doing the mean of those values (Jiménez-Valverde 2020).
}
\examples{
suit<-rbeta(100, 2, 2) # Generate suitability values
random<-runif(100)
sp<-ifelse(random < suit, 1, 0) # Generate presence-absence data
result<-AUCuniform(cbind(suit, sp), plot = TRUE, plot.adds = TRUE)
result$uAUC.95CI[2] # Get the uAUC
}
\references{
Bamber, D. (1975). The Area above the Ordinal Dominance Graph and
    the Area below the Receiver Operating Characteristic Graph.
    \emph{J. Math. Psychol}., 12, 387-415.

    Jiménez-Valverde, A. (2020). Sample size for the evaluation of
    presence-absence models. \emph{Ecol. Indic}., 114, 106289.

    Jiménez-Valverde, A. (2022). The uniform AUC: dealing with the
    representativeness effect in presence-absence models. \emph{Methods Ecol.
    Evol.}, 13, 1224-1236.
}
