% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_contradicting_if_rules.R
\name{detect_contradicting_if_rules}
\alias{detect_contradicting_if_rules}
\title{Detect contradictory if-rules}
\usage{
detect_contradicting_if_rules(x, ..., verbose = interactive())
}
\arguments{
\item{x}{A validator object.}

\item{...}{Additional arguments passed to \code{detect_if_clauses}.}

\item{verbose}{Logical. If \code{TRUE}, print the results.}
}
\value{
A list of contradictions found in the if clauses, or \code{NULL} if none are found.
}
\description{
Detect whether conditions in conditional if-rules may generate contradictions. Strictly
speaking these rules do not make the rule set infeasible but rather make
the if-condition unsatisfiable.
Semantically speaking these rules are
contradicting, because the writer of the rule set did not have the intention
to make the condition forbidden.
}
\details{
In general it detects (variations on) cases where:
\itemize{
\item \code{if (A) B} and \code{if (A) !B}, which probably is not intended, but logically equals \code{!A}.
\item \code{if (A) B} and \code{if (B) !A}, which probably is not intended but logically equals \code{!A}.
}

See examples for more details.
}
\examples{
rules <- validator(
  if (nace == "a") export == "y",
  if (nace == "a")  export == "n"
)

conflicts <- detect_contradicting_if_rules(rules, verbose=TRUE)

print(conflicts)


# this creates a implicit contradiction when income > 0
rules <- validator(
  rule1 = if (income > 0) job == "yes",
  rule2 = if (job == "yes") income == 0
)

conflicts <- detect_contradicting_if_rules(rules, verbose=TRUE)

}
\seealso{
Other feasibility: 
\code{\link{detect_boundary_cat}()},
\code{\link{detect_boundary_num}()},
\code{\link{detect_infeasible_rules}()},
\code{\link{is_contradicted_by}()},
\code{\link{is_infeasible}()},
\code{\link{make_feasible}()}
}
\concept{feasibility}
