% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join-data.R
\name{map_with_data}
\alias{map_with_data}
\title{Join county or state level data to US map data}
\usage{
map_with_data(
  data,
  values = "values",
  include = c(),
  exclude = c(),
  na = NA,
  data_year = NULL
)
}
\arguments{
\item{data}{The data that should be joined to a US map. This
parameter should be a data frame consisting of two columns,
a fips code (2 characters for state, 5 characters for county)
and the value that should be associated with that region. The
columns of \code{data} \emph{must} be \code{fips} or \code{state} and
the value of the \code{values} parameter. If both \code{fips} and \code{state}
are provided, this function uses the \code{fips}.}

\item{values}{The name of the column that contains the values to be associated
with a given region. The default is \code{"values"}.}

\item{include}{The regions to include in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or FIPS code.
For counties, the FIPS must be provided as there can be multiple counties with the
same name. If states are provided in the county map, only counties in the included states
will be returned.}

\item{exclude}{The regions to exclude in the resulting map. If \code{regions} is
\code{"states"}/\code{"state"}, the value can be either a state name, abbreviation or FIPS code.
For counties, the FIPS must be provided as there can be multiple counties with the
same name. The regions listed in the \code{include} parameter take precedence over
regions listed in \code{exclude}. If both parameters include the same region(s) they
will be included in the map.}

\item{na}{The value to be inserted for states or counties that don't have
a value in \code{data}. This value must be of the same type as the \code{value}
column of \code{data}.}

\item{data_year}{The year for which to obtain map data.
If the value is \code{NULL}, the most recent year's data is used. If the
provided year is not found from the available map data sets, the next most
recent year's data is used. This can be used if an older data set is being
plotted on the US map so that the data matches the map more accurately.
Therefore, the provided value should match the year of the plotted data set.
The default is \code{NULL}, i.e. the most recent available year is used.}
}
\value{
A data frame composed of the map data frame (from \code{\link[=us_map]{us_map()}}) except
an extra column containing the values in \code{data} is included.

The result can be plotted using \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} or \code{\link[=plot_usmap]{plot_usmap()}}.
}
\description{
Join county or state level data to US map data
}
\examples{
state_data <- data.frame(fips = c("01", "02", "04"), values = c(1, 5, 8))
df <- map_with_data(state_data, na = 0)

state_data <- data.frame(state = c("AK", "CA", "Utah"), values = c(6, 9, 3))
df <- map_with_data(state_data, na = 0)

}
\seealso{
\code{\link[=plot_usmap]{plot_usmap()}}
}
