% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doj_press_releases.R
\name{doj_press_releases}
\alias{doj_press_releases}
\title{Retrieve DOJ Press Releases}
\usage{
doj_press_releases(
  n_results = 50,
  search_direction = "DESC",
  keyword = NULL,
  clean = TRUE
)
}
\arguments{
\item{n_results}{Integer. Number of press releases to retrieve. Default is 50.}

\item{search_direction}{Character. "ASC" or "DESC" for ascending or descending sort by date. Default is "DESC".}

\item{keyword}{Optional character string to filter results by keyword.}

\item{clean}{Logical. If TRUE, cleans up the text fields. Default is TRUE.}
}
\value{
A cleaned dataframe containing DOJ press release metadata and content.
}
\description{
This function retrieves press releases from the U.S. Department of Justice API.
You can specify the number of results, search direction, and optional keyword filtering.
}
\examples{
\dontrun{
# Retrieve a single DOJ press release
result <- doj_press_releases(n_results = 1)
print(result)
}

}
