% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{Statistics}
\alias{Statistics}
\title{Statistics of Estimated Value of Causal Mediation Effects}
\usage{
Statistics (m_model, y_model, data, X, exp0=NULL, exp1=NULL, M, Y,
m_type, y_type, boot_num = 100, MT = TRUE, Cf_lv = 0.95)
}
\arguments{
\item{m_model}{a fitted model object for the mediator.}

\item{y_model}{a fitted model object for the outcome.}

\item{data}{a dataframe used in the analysis.}

\item{X}{a character variable of the exposure's name.}

\item{exp0}{a numeric variable of the baseline level of the exposure.}

\item{exp1}{a numeric variable of the new level of the exposure.}

\item{M}{a character variable of the mediator's name.}

\item{Y}{a character variable of the outcome's name.}

\item{m_type}{a character variable of the mediator's type.}

\item{y_type}{a character variable of the outcome's type.}

\item{boot_num}{the times of bootstrapping in the analysis. The default is 100.}

\item{MT}{a logical value indicating whether the multi-threading process is activated. If TURE, activating max-1 cores.
If FALSE, use the ordinary 'for' loop. The default is \code{TRUE}.}

\item{Cf_lv}{a numeric variable of the confidence interval. The value is presented in decimal form, not percentage form.
The default is 0.95.}
}
\value{
This function returns a list of three dataframes, i.e., statistics of the mediation effects risk difference (RD), odds ratio (OR) and risk ratio (RR) scales respectively.
The statistics include the mean value, standard error, t-statistics, p-value and confident interval based on the bootstrapping estimations.
}
\description{
This function calculates the statistics of mediation effects
risk difference (RD), odds ratio (OR) and risk ratio (RR) scales based on the bootstrapping results. The statistics include
the mean value, standard error, t-statistics, p-value and confident interval.
The way to realize bootstrapping estimations is also specified in this function,
either through the ordinal \code{for} loop, or the multi-threading process.

This is an internal function, automatically called by the function \code{\link{FormalEstmed}}.
}
\details{
This function also detects the treatment group and control group when the exposure
is not a continuous variable. The function deals with o-1 exposure, character and factor exposure and then
displays the grouping information for users.
}
