% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleEstimation.R
\name{SingleEstimation}
\alias{SingleEstimation}
\title{Single-time Estimation for Causal Mediation Effects}
\usage{
SingleEstimation (m_model, y_model, data, X, exp0=NULL, exp1=NULL,
M, Y, m_type, y_type)
}
\arguments{
\item{m_model}{a fitted model object for the mediator.}

\item{y_model}{a fitted model object for the outcome.}

\item{data}{a dataframe used in the analysis.}

\item{X}{a character variable of the exposure's name.}

\item{exp0}{a numeric variable of the baseline level of the exposure.}

\item{exp1}{a numeric variable of the new level of the exposure.}

\item{M}{a character variable of the mediator's name.}

\item{Y}{a character variable of the outcome's name.}

\item{m_type}{a character variable of the mediator's type.}

\item{y_type}{a character variable of the outcome's type.}
}
\value{
This function returns a list of three dataframes of mediation effects on
risk difference (RD), odds ratio (OR) and risk ratio (RR) scales.
Each dataframe has only one single estimate for each effect.
}
\description{
This function obtains the estimates of various types of mediation effects
for a single time based on one bootstrap sample. This function calculates the effects through
different combinations of potential outcomes by the algorithm we proposed.

This is an internal function, automatically called by the function \code{\link{BootEstimation_for}} or \code{\link{BootEstimation_MT}}.
}
