% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlgompertz.R
\name{mlgompertz}
\alias{mlgompertz}
\title{Gompertz distribution maximum likelihood estimation}
\usage{
mlgompertz(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{\code{reltol} is the relative accuracy requested, defaults
to \code{.Machine$double.eps^0.25}. \code{iterlim} is a positive integer
specifying the maximum number of iterations to be performed before the
program is terminated (defaults to \code{100}).}
}
\value{
\code{mlgompertz} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{a} and \code{b} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
Uses Newton-Raphson to estimate the parameters of the Gompertz distribution.
}
\details{
For some data sets the maximum likelihood estimator of \code{b} fails to exist
since the root of the profile maximum likelihood equation is non-positive.
The value \code{1e-06} is returned in this case, along with a warning.

For the density function of the Gompertz distribution see
\link[extraDistr:Gompertz]{Gompertz}.
}
\examples{
mlgompertz(precip)
}
\references{
Lenart, A. (2012). The Gompertz distribution and Maximum Likelihood Estimation of its parameters - a revision. MPIDR WORKING PAPER WP 2012-008. https://www.demogr.mpg.de/papers/working/wp-2012-008.pdf
}
\seealso{
\link[extraDistr:Gompertz]{Gompertz} for the Gompertz density.
}
