% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlbinom.R
\name{mlbinom}
\alias{mlbinom}
\title{Binomial distribution maximum likelihood estimation}
\usage{
mlbinom(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{logical. Should missing values be removed?}

\item{...}{The arguments \code{size} can be specified to only return the ml of \code{prob}.
\code{reltol} is the relative accuracy requested,
defaults to \code{.Machine$double.eps^0.25}. \code{iterlim} is a positive integer
specifying the maximum number of iterations to be performed before the
program is terminated (defaults to \code{100}).}
}
\value{
\code{mlbinom} returns an object of \link[base:class]{class} \code{univariateML}.
This is a named numeric vector with maximum likelihood estimates for
\code{size} and \code{prob} and the following attributes:
\item{\code{model}}{The name of the model.}
\item{\code{density}}{The density associated with the estimates.}
\item{\code{logLik}}{The loglikelihood at the maximum.}
\item{\code{support}}{The support of the density.}
\item{\code{n}}{The number of observations.}
\item{\code{call}}{The call as captured my \code{match.call}}
}
\description{
For the density function of the Binomial distribution see
\link[stats:Binomial]{Binomial}.
}
\details{
The estimator computes both the \code{size} and \code{prob} parameter by default. Be aware
that the likelihood will often be unbounded. According to Olkin et al. (1981),
the likelihood is unbounded when \eqn{\hat{\mu}/\hat{\sigma}^2 \leq 1},
where \eqn{\hat{\sigma}^2} is the biased sample variance. When the likelihood
is unbounded,the maximum likelihood estimator can be regarded as a \link[stats:Poisson]{Poisson}
with \code{lambda} parameter equal to the mean of the observation.

When \eqn{\hat{\mu}/\hat{\sigma}^2 \leq 1} and \code{size} is not supplied by the user,
an error is cast. If \code{size} is provided and \code{size < max(x)}, an error is cast.

The maximum likelihood estimator of \code{size} is unstable, and improvements exist.
See, e.g., Carroll and Lomard (1985) and DasGupta and Rubin (2005).
}
\examples{
# The likelihood will often be unbounded.
\dontrun{
mlbinom(ChickWeight$weight)
}
# Provide a size
mlbinom(ChickWeight$weight, size = 400)

# Or use mlpoiss, the limiting likelihood of the binomial.
mlpois(ChickWeight$weight)
}
\references{
Olkin, I., Petkau, A. J., & Zidek, J. V. (1981). A comparison of n Estimators for the binomial distribution. Journal of the American Statistical Association, 76(375), 637-642. https://doi.org/10.1080/01621459.1981.10477697

Johnson, N. L., Kemp, A. W., & Kotz, S. (2005). Univariate Discrete Distributions (3rd ed.). Wiley-Blackwell.

Carroll, R. J., & Lombard, F. (1985). A Note on N Estimators for the Binomial Distribution. Journal of the American Statistical Association, 80(390), 423-426. https://doi.org/10.1080/01621459.1985.10478134

DasGupta, A., & Rubin, H. (2005). Estimation of binomial parameters when both n,p are unknown. Journal of Statistical Planning and Inference, 130(1-2), 391-404. https://doi.org/10.1016/j.jspi.2004.02.019
}
\seealso{
\link[stats:Binomial]{Binomial} for the density.
}
