% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wollongong.R
\docType{data}
\name{wollongong_1}
\alias{wollongong_1}
\title{Primary colours of the University of Wollongong, Australia}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on UOW's  
\href{https://www.uow.edu.au/brand/brand-system/colour/}{colour guide}.
}
\usage{
wollongong_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{wollongong_1} provides the four primary colours 
of the \href{https://www.uow.edu.au}{University of Wollongong}, NSW, Australia.
}
\details{
The 4 primary colours are 
\code{"white"} (defined as HEX \code{"#FFFFFF"}), 
\code{Dark blue} (HEX \code{"#001641"}), 
\code{Bright blue} (HEX \code{"#0033FF"}), and 
\code{UOW red} (HEX \code{"#ED0A00"}).

Each colour plays a role across communications and environments to create engaging experiences through logo, 
typography, illustration, iconography and image overlay.


The UOW colours are modern, bold and progressive, and reflect brand personality and brand values. 
The strong, credible palette can be used across all areas of communication and projects a positive and progressive place to learn.

The UOW colour palette is 'open' meaning that it does not colour code by unit, division or faculty. 
This flexibility means greater choice, expression and diversity.

Refer to the \href{https://www.uow.edu.au/brand/brand-system/colour/}{colour guide} 
for official breakdowns and accessibility guidance.
}
\examples{
wollongong_1
unikn::seecol(wollongong_1, col_bg = "lightgrey", 
              main = "Primary colours of the University of Wollongong") # view color palette

}
\seealso{
\code{\link{wollongong_2}} for secondary colours of the University of Wollongong;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Australian university color palettes: 
\code{\link{anu_1}},
\code{\link{anu_2}},
\code{\link{mq_1}},
\code{\link{mq_2}},
\code{\link{wollongong_2}}
}
\author{
\strong{unicol}, 2023-09-06.
}
\concept{Australian university color palettes}
\keyword{datasets}
