% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stirling.R
\docType{data}
\name{stirling_1}
\alias{stirling_1}
\title{Primary colours of the University of Stirling, Scotland}
\format{
An object of class \code{character} of length 2.
}
\source{
Color definitions are based on \href{https://www.stir.ac.uk}{Stirling}'s 
\href{https://www.stir.ac.uk/brand-bank/brand-assets/}{Brand guide}.
}
\usage{
stirling_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{stirling_1} provides the two primary colours 
of the \href{https://www.stir.ac.uk}{University of Stirling}, Scotland, UK.
}
\details{
The 2 primary colours are 
\code{Heritage green}, defined as PMS Pantone 349, RGB 0 105 56, CMYK 90 32 93 24, or HEX "#006938", and 
\code{Energy green}, defined as PMS Pantone 368, RGB 119 191 34, CMYK 60 0 100 0, or HEX "#77BF22".

\code{stirling_1} uses the HEX color definitions.


The \href{https://www.stir.ac.uk}{University of Stirling}'s colour palette 
plays a vital role in delivering a visibly consistent look to all communications. 

Our primary colour palette has been carefully chosen to identify and differentiate us. 
The green primary colour reflects the natural beauty of \href{https://www.stir.ac.uk}{Stirling}'s campus. 

The primary colours are supported by the secondary palette (see \code{\link{stirling_2}}) and 
tertiary colours (\code{\link{stirling_3}}) for body text and messaging.

The primary and secondary colour palettes are made up of colour pairings: 
‘Energy colours’ and ‘Heritage colours’. 
These can be used separately, mixed, or as the pairings suggested.

To add flexibility, users can use tints (70%, 50%, 30%) of a chosen colour.
}
\examples{
stirling_1
unikn::seecol(stirling_1, main = "Primary colours of the University of Stirling") # view palette

}
\seealso{
\code{\link{stirling_2}} for secondary colours of the University of Stirling; 
\code{\link{stirling_3}} for tertiary colours of the University of Stirling; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Scottish university color palettes: 
\code{\link{dundee_background}},
\code{\link{dundee_block}},
\code{\link{dundee_core}},
\code{\link{dundee_highlight}},
\code{\link{edinburgh}},
\code{\link{standrews_1}},
\code{\link{standrews_2}},
\code{\link{stirling_2}},
\code{\link{stirling_3}}
}
\author{
\strong{unicol}, 2023-09-16.
}
\concept{Scottish university color palettes}
\keyword{datasets}
