% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.uniReg.R
\name{plot.cv.uniReg}
\alias{plot.cv.uniReg}
\title{plot the cross-validation curve produced by cv.uniReg}
\usage{
\method{plot}{cv.uniReg}(x, ...)
}
\arguments{
\item{x}{fitted \code{"cv.uniReg"} object, which inherits from \code{"cv.uniLasso"}.
negative if \code{sign.lambda=-1}.}

\item{\dots}{Other graphical parameters to plot}
}
\value{
A plot is produced, and nothing is returned.
}
\description{
Plots the cross-validation \code{cv.uniLasso} curve (which is a \code{cv.glmnet} curve), and upper and lower standard deviation
curves, as a function of the \code{lambda} values used. It highlights the value at the end of the path, which is either \code{lambda = 0}, or else the smallest \code{lambda} if \code{hard.zero = FALSE}.
}
\details{
A plot is produced, and nothing is returned.
}
\examples{

set.seed(1010)
n = 1000
p = 100
nzc = trunc(p/10)
x = matrix(rnorm(n * p), n, p)
beta = rnorm(nzc)
fx = (x[, seq(nzc)] \%*\% beta)
eps = rnorm(n) * 5
y = drop(fx + eps)
cvob0 = cv.uniReg(x, y)
plot(cvob0)
cvob = cv.uniReg(x, y, hard.zero = FALSE)
plot(cvob)

}
\seealso{
\code{cv.uniLasso} and \code{glmnet:::cv.glmnet}.
}
\author{
Trevor Hastie and Rob Tibshirani\cr Maintainer:
Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{models}
\keyword{regression}
