% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umx_build_umxSimplex.R
\name{umxSimplex}
\alias{umxSimplex}
\title{Build and run a simplex twin model (not ready for use!)}
\usage{
umxSimplex(
  name = "simplex",
  selDVs,
  dzData,
  mzData,
  sep = "_T",
  equateMeans = TRUE,
  dzAr = 0.5,
  dzCr = 1,
  addStd = TRUE,
  addCI = TRUE,
  autoRun = getOption("umx_auto_run"),
  tryHard = c("no", "yes", "ordinal", "search"),
  optimizer = NULL
)
}
\arguments{
\item{name}{The name of the model (defaults to "simplex")}

\item{selDVs}{The BASENAMES of the variables i.e., c(\code{obese}), not c(\code{obese_T1}, \code{obese_T2})}

\item{dzData}{The DZ dataframe}

\item{mzData}{The MZ dataframe}

\item{sep}{The string preceding the final numeric twin identifier (often "_T")
Combined with selDVs to form the full var names, i.e., just "dep" --> c("dep_T1", "dep_T2")}

\item{equateMeans}{Whether to equate the means across twins (defaults to TRUE).}

\item{dzAr}{The DZ genetic correlation (default = .5. Vary to examine assortative mating).}

\item{dzCr}{The DZ "C" correlation (defaults = 1. To make an ADE model, set = .25).}

\item{addStd}{Whether to add the algebras to compute a std model (default = TRUE).}

\item{addCI}{Whether to add the interval requests for CIs (default = TRUE).}

\item{autoRun}{Whether to run the model (default), or just to create it and return without running.}

\item{tryHard}{Default ('no') uses normal mxRun. "yes" uses mxTryHard. Other options: "ordinal", "search"}

\item{optimizer}{Optionally set the optimizer (default NULL does nothing).}
}
\value{
\itemize{
\item \code{\link[OpenMx:mxModel]{OpenMx::mxModel()}}
}
}
\description{
The simplex model provides a powerful tool for theory-based decomposition of genetic
and environmental differences. \code{umxSimplex} makes a 2-group simplex twin model.

\strong{This code is beta} quality: \strong{not} for publication use.
}
\details{
The simplex model decomposes phenotypic variance
into Additive genetic, unique environmental (E) and, optionally, either
common or shared-environment (C) or non-additive genetic effects (D).

In the simplex model, these influences are modeled as a combination of:
\itemize{
\item Innovations at a given time (\code{ai} \code{ci} and \code{ei} matrices).
\item Influences transmitted from previous time (\code{at}, \code{ct}, and \code{et} matrices).
\item Influences specific to a single time (\code{as}, \code{cs}, \code{es}).
}

These combine to explain the causes of variance in the phenotype (see Figure).

\strong{Simplex path diagram}:

\if{html}{\figure{simplex.png}{options: style="width: 50\%;" alt="Figure: simplex.png"}}
\if{latex}{\figure{simplex.pdf}{options: width=7cm}}

\strong{Data Input}
Currently, the umxSimplex function accepts only raw data.

\strong{Ordinal Data}
In an important capability, the model transparently handles ordinal (binary or multi-level
ordered factor data) inputs, and can handle mixtures of continuous, binary, and ordinal
data in any combination.

\strong{Additional features}
The \code{umxSimplex} function supports varying the DZ genetic association (defaulting to .5)
to allow exploring assortative mating effects, as well as varying the DZ \dQuote{C} factor
from 1 (the default for modeling family-level effects shared 100\% by twins in a pair),
to .25 to model dominance effects.

\strong{Matrices and Labels in the simplex model}
A good way to see which matrices are used in umxSummary is to run an example model and plot it.

The loadings specific to each time point are contained on the diagonals of matrices
\code{as}, \code{cs}, and \code{es}. So labels relevant to modifying these are of the form "as_r1c1", "as_r2c2" etc.

All the shared matrices are in the model "top". So to see the 'as' values, you can simply execute:

\code{m1$top$as$values}

The transmitted loadings are in matrices \code{at}, \code{ct}, \code{et}.

The innovations are in the matrix \code{ai}, \code{ci}, and \code{ei}.

Less commonly-modified matrices are the mean matrix \code{expMean}.
This has 1 row, and the columns are laid out for each variable for
twin 1, followed by each variable for twin 2.

Thus, in a model where the means for twin 1 and twin 2 had been equated
(set = to T1), you could make them independent again with this script:

\code{m1$top$expMean$labels[1,4:6] = c("expMean_r1c4", "expMean_r1c5", "expMean_r1c6")}
}
\examples{
\dontrun{
data(iqdat)
mzData = subset(iqdat, zygosity == "MZ")
dzData = subset(iqdat, zygosity == "DZ")
baseVars = c("IQ_age1", "IQ_age2", "IQ_age3", "IQ_age4")
m1= umxSimplex(selDVs= baseVars, dzData= dzData, mzData= mzData, sep= "_T", tryHard= "yes")

umxSummary(m1)
parameters(m1, patt = "^s")
m2 = umxModify(m1, regex = "as_r1c1", name = "no_as", comp = TRUE)
umxCompare(m1, m2)

# =============================
# = Test a 3 time-point model =
# =============================
m1 = umxSimplex(selDVs = paste0("IQ_age", 1:3), 
dzData = dzData, mzData = mzData, tryHard = "yes")
}
}
\references{
\itemize{
\item \url{https://github.com/tbates/umx}
}
}
\seealso{
\itemize{
\item \code{\link[=umxACE]{umxACE()}} for more examples of twin modeling, \code{\link[=plot]{plot()}}, \code{\link[=umxSummary]{umxSummary()}} work for IP, CP, GxE, SAT, and ACE models.
}

Other Twin Modeling Functions: 
\code{\link{power.ACE.test}()},
\code{\link{umx}},
\code{\link{umxACE}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxCP}()},
\code{\link{umxDiffMZ}()},
\code{\link{umxDiscTwin}()},
\code{\link{umxDoC}()},
\code{\link{umxDoCp}()},
\code{\link{umxGxE}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxIP}()},
\code{\link{umxMRDoC}()},
\code{\link{umxReduce}()},
\code{\link{umxReduceACE}()},
\code{\link{umxReduceGxE}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSummarizeTwinData}()},
\code{\link{umxSummaryACE}()},
\code{\link{umxSummaryACEv}()},
\code{\link{umxSummaryDoC}()},
\code{\link{umxSummaryGxEbiv}()},
\code{\link{umxSummarySexLim}()},
\code{\link{umxSummarySimplex}()},
\code{\link{umxTwinMaker}()}
}
\concept{Twin Modeling Functions}
